/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class EclipseProjUtil {
    static final String PROPERTIES_PAGE_ID = "org.telosys.tools.eclipse.plugin.config.view.PropertiesPage";

    private EclipseProjUtil() {
    }

    private static void log(String s) {
    }

    public static String getProjectDir(IProject project) {
        if (project != null) {
            IPath path = project.getLocation();
            if (path != null) {
                return path.toOSString();
            }
            MsgBox.error("getProjectDir() : Project location is null ");
            return null;
        }
        MsgBox.error("getProjectDir() : Project is null ");
        return null;
    }

    public static IResource getResource(IProject project, String sPath) {
        EclipseProjUtil.log("getResource(String : '" + sPath + "')");
        IResource resource = EclipseProjUtil.getResource(project, new Path(sPath));
        EclipseProjUtil.log("getResource(String : '" + sPath + "') : return " + resource);
        return resource;
    }

    public static IResource getResource(IProject project, Path path) {
        EclipseProjUtil.log("getResource(Path : '" + path + "')");
        IFile resource = project.getFile((IPath)path);
        if (!resource.exists() && !(resource = project.getFolder((IPath)path)).exists()) {
            resource = null;
        }
        EclipseProjUtil.log("getResource(Path : '" + path + "') : return " + resource);
        return resource;
    }

    public static String getWorkspaceLocation(IProject project) {
        IWorkspace wks = project.getWorkspace();
        IWorkspaceRoot wksRoot = wks.getRoot();
        IPath wksLocation = wksRoot.getLocation();
        if (wksLocation != null) {
            return wksLocation.toOSString();
        }
        return "unknown";
    }

    public static String getAbsolutePathInWorkspace(IProject project, String sPath) {
        IFile file = project.getFile((IPath)new Path(sPath));
        IPath p = file.getFullPath();
        return p.toString();
    }

    public static String getAbsolutePathInFileSystem(IProject project, String sPath) {
        IFile resource = project.getFile((IPath)new Path(sPath));
        IPath ipath = resource.getLocation();
        File file = ipath.toFile();
        return file.getAbsolutePath();
    }

    public static File getResourceAsFile(IProject project, String sPath) {
        EclipseProjUtil.log("getResourceAsFile(String : '" + sPath + "')");
        File file = EclipseProjUtil.getResourceAsFile(project, new Path(sPath));
        EclipseProjUtil.log("getResourceAsFile(String : '" + sPath + "') : return " + file);
        return file;
    }

    private static File getResourceAsFile(IProject project, Path path) {
        File file = null;
        EclipseProjUtil.log("getResourceAsFile(Path : '" + path + "')");
        IResource resource = EclipseProjUtil.getResource(project, path);
        if (resource != null) {
            EclipseProjUtil.log("getResourceAsFile() : resource exists ? " + resource.exists());
            EclipseProjUtil.log("getResourceAsFile() : resource getLocation() : " + resource.getLocation());
            EclipseProjUtil.log("getResourceAsFile() : resource getFullPath() : " + resource.getFullPath());
            IPath ipath = resource.getLocation();
            file = ipath.toFile();
            if (!file.exists()) {
                file = null;
            }
        }
        EclipseProjUtil.log("getResourceAsFile(Path : '" + path + "') : return " + file);
        return file;
    }

    public static void refreshFile(IProject project, String path) {
        EclipseProjUtil.refreshFile(project, new Path(path));
    }

    public static void refreshFolder(IProject project, String path) {
        EclipseProjUtil.refreshFolder(project, new Path(path));
    }

    public static void refreshFile(IProject project, Path path) {
        IFile iFile = project.getFile((IPath)path);
        try {
            iFile.refreshLocal(0, null);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot refresh file '" + path + "' !", e);
        }
    }

    public static void refreshFolder(IProject project, Path path) {
        IFolder iFolder = project.getFolder((IPath)path);
        try {
            iFolder.refreshLocal(2, null);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot refresh folder '" + path + "' !", e);
        }
    }

    public static void refreshResource(IProject project, Path path) {
        IFile iResource = project.getFile((IPath)path);
        if (iResource.exists()) {
            try {
                if (iResource instanceof IFile) {
                    IFile iFile = iResource;
                    iFile.refreshLocal(0, null);
                } else if (iResource instanceof IFolder) {
                    IFolder iFolder = (IFolder)iResource;
                    iFolder.refreshLocal(2, null);
                }
            }
            catch (CoreException e) {
                MsgBox.error("Cannot refresh '" + path + "' !", e);
            }
        } else {
            MsgBox.error("Cannot refresh '" + path + "' !\n" + "This resource doesn't exist");
        }
    }

    public static IJavaModel getJavaModel() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)workspace.getRoot());
            return javaModel;
        }
        MsgBox.error("Cannot get JavaModel because workspace is null !");
        return null;
    }

    public static IJavaProject getJavaProject(String sProjectName) {
        IJavaModel javaModel = EclipseProjUtil.getJavaModel();
        if (javaModel != null) {
            return javaModel.getJavaProject(sProjectName);
        }
        MsgBox.error("Cannot get JavaProject because JavaModel is null !");
        return null;
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ce) {
            MsgBox.error("Cannot get project nature (project is null or not open) \n\n isJavaProject(project) ", ce);
            return false;
        }
        catch (Exception e) {
            MsgBox.error("Cannot get project nature\n\n isJavaProject(project) ", e);
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (EclipseProjUtil.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        MsgBox.error("This project is not a Java project \n\n getJavaProject(project) ");
        return null;
    }

    public static String[] getClassPathLibraries(IProject project) {
        IJavaProject javaProject = EclipseProjUtil.getJavaProject(project);
        if (javaProject != null) {
            List<String> libraries = EclipseProjUtil.getProjectClassPathLibraries(javaProject);
            return libraries.toArray(new String[0]);
        }
        return new String[0];
    }

    private static List<String> getProjectClassPathLibraries(IJavaProject project) {
        IClasspathEntry[] classpathEntries;
        ArrayList<String> libraries = new ArrayList<String>();
        try {
            classpathEntries = project.getResolvedClasspath(false);
        }
        catch (JavaModelException e) {
            MsgBox.error("Cannot get Java libraries for this project.\n\nCheck the 'build path' ");
            e.printStackTrace();
            return libraries;
        }
        int i = 0;
        while (i < classpathEntries.length) {
            File file;
            IClasspathEntry entry = classpathEntries[i];
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(entry.getPath());
            if (resource != null) {
                PluginLogger.log("Project resource : '" + entry.getPath() + "'");
                file = new File(resource.getLocation().toPortableString());
                libraries.add(file.getAbsolutePath());
            } else {
                PluginLogger.log("External resource : '" + entry.getPath() + "'");
                file = entry.getPath().toFile();
                libraries.add(file.getAbsolutePath());
            }
            ++i;
        }
        return libraries;
    }

    public static String[] getSrcFolders(IProject project) {
        IClasspathEntry[] entries;
        LinkedList<String> srcFolders = new LinkedList<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (Exception exception) {
            MsgBox.error("Cannot get JavaProject raw class path !");
            return new String[0];
        }
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
            if (classPathEntry.getEntryKind() == 3) {
                IPath path = classPathEntry.getPath();
                IFolder srcFolder = project.getWorkspace().getRoot().getFolder(path);
                IPath relativePath = srcFolder.getProjectRelativePath();
                srcFolders.add(relativePath.toString());
            }
            ++n2;
        }
        return srcFolders.toArray(new String[0]);
    }

    public static boolean folderExists(IProject project, String folderName) {
        IFolder folder = project.getFolder(folderName);
        return folder.exists();
    }

    public static boolean createFolder(IProject project, String folderName) {
        if (project.getFolder(folderName).exists()) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        String[] parts = StrUtil.split((String)folderName, (char)'/');
        int i = 0;
        while (i < parts.length) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(parts[i]);
            IFolder folder = project.getFolder(sb.toString());
            if (!folder.exists()) {
                try {
                    folder.create(0, true, null);
                }
                catch (CoreException e) {
                    MsgBox.error("Cannot create folder '" + folder.getName() + "' !\n", e);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static void openTelosysPropertiesView(IProject project) {
        if (project != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)PROPERTIES_PAGE_ID, (String[])new String[]{PROPERTIES_PAGE_ID}, null);
            dialog.open();
        } else {
            MsgBox.error("Cannot open properties view : the given project is null ");
        }
    }
}

