/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.telosys.tools.commons.FileUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

public class EclipseWksUtil {
    private EclipseWksUtil() {
    }

    private static void log(String s) {
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return EclipseWksUtil.getWorkspace().getRoot();
    }

    public static IProject[] getWorkspaceProjects() {
        IProject[] projects = EclipseWksUtil.getWorkspace().getRoot().getProjects();
        return projects;
    }

    public static String getWorkspaceLocation() {
        IWorkspace wks = EclipseWksUtil.getWorkspace();
        IWorkspaceRoot wksRoot = wks.getRoot();
        IPath wksLocation = wksRoot.getLocation();
        if (wksLocation != null) {
            return wksLocation.toString();
        }
        throw new IllegalStateException("Cannot get workspace location");
    }

    public static IPath getIPath(String sPath) {
        EclipseWksUtil.log("getFullPath(String : '" + sPath + "')");
        IPath p = EclipseWksUtil.getIPath(new Path(sPath));
        EclipseWksUtil.log("getFullPath(String : '" + sPath + "') : return '" + p + "'");
        return p;
    }

    private static IPath getIPath(Path path) {
        IPath p = null;
        EclipseWksUtil.log("getFullPath(Path : '" + path + "')");
        IResource resource = EclipseWksUtil.getWorkspaceRoot().findMember((IPath)path);
        if (resource == null) {
            MsgBox.error("Cannot find '" + path + "' in the workspace !");
            p = null;
        } else if (resource.exists()) {
            EclipseWksUtil.log("Resource '" + path + "' exists ");
            p = resource.getFullPath();
        } else {
            EclipseWksUtil.log("Resource '" + path + "' doesn't exist ");
            p = null;
        }
        EclipseWksUtil.log("getFullPath(Path : '" + path + "') : return '" + p + "'");
        return p;
    }

    public static IResource getResource(String sPath) {
        EclipseWksUtil.log("getResource(String : '" + sPath + "')");
        IResource resource = EclipseWksUtil.getResource(new Path(sPath));
        EclipseWksUtil.log("getResource(String : '" + sPath + "') : return " + resource);
        return resource;
    }

    public static IResource getResource(Path path) {
        EclipseWksUtil.log("getResource(Path : '" + path + "')");
        IResource resource = EclipseWksUtil.getWorkspaceRoot().findMember((IPath)path);
        EclipseWksUtil.log("getResource(Path : '" + path + "') : return " + resource);
        return resource;
    }

    public static File getResourceAsFile(String sPath) {
        EclipseWksUtil.log("getResourceAsFile(String : '" + sPath + "')");
        File file = EclipseWksUtil.getResourceAsFile(new Path(sPath));
        EclipseWksUtil.log("getResourceAsFile(String : '" + sPath + "') : return " + file);
        return file;
    }

    public static File getResourceAsFile(Path path) {
        File file = null;
        EclipseWksUtil.log("getResourceAsFile(Path : '" + path + "')");
        IResource resource = EclipseWksUtil.getResource(path);
        if (resource != null) {
            EclipseWksUtil.log("getResourceAsFile() : resource exists ? " + resource.exists());
            EclipseWksUtil.log("getResourceAsFile() : resource getLocation() : " + resource.getLocation());
            EclipseWksUtil.log("getResourceAsFile() : resource getFullPath() : " + resource.getFullPath());
            IPath ipath = resource.getLocation();
            file = ipath.toFile();
            if (!file.exists()) {
                file = null;
            }
        } else {
            EclipseWksUtil.log("Cannot get resource : getResource('" + path + "') return null ");
        }
        EclipseWksUtil.log("getResourceAsFile(Path : '" + path + "') : return " + file);
        return file;
    }

    public static IFolder createFolder(String sFolderPath) {
        return EclipseWksUtil.createFolder((IPath)new Path(sFolderPath));
    }

    public static IFolder createFolder(IPath path) {
        EclipseWksUtil.log("createFolder( IPath ) : path = " + path);
        IFolder folder = EclipseWksUtil.getWorkspaceRoot().getFolder(path);
        IContainer parent = folder.getParent();
        if (parent != null) {
            EclipseWksUtil.log("createFolder( IPath ) : parent path = " + parent.getFullPath());
            if (parent instanceof IFolder && !parent.exists()) {
                EclipseWksUtil.createFolder(parent.getFullPath());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                MsgBox.error("Cannot create folder '" + folder.getFullPath() + "'", e);
                return null;
            }
            return folder;
        }
        MsgBox.error("Folder '" + folder.getFullPath() + "' parent is null ");
        return null;
    }

    public static IFolder toIFolder(File file) {
        EclipseWksUtil.log("toIFolder( File ) : file = " + file.getAbsolutePath());
        String sAbsolutePath = file.getAbsolutePath();
        Path path = new Path(sAbsolutePath);
        return EclipseWksUtil.toIFolder((IPath)path);
    }

    public static IFolder toIFolder(IPath path) {
        EclipseWksUtil.log("toIFolder( IPath ) : path = " + path);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root != null) {
            IContainer iContainer = root.getContainerForLocation(path);
            if (iContainer != null) {
                if (iContainer instanceof IFolder) {
                    return (IFolder)iContainer;
                }
                MsgBox.error("toIFolder(file) : the IContainer is not a FOLDER");
                return null;
            }
            MsgBox.error("toIFolder(file) : root.getContainerForLocation('" + path + "') return NULL");
            return null;
        }
        MsgBox.error("toIFolder(file) : Cannot get workspace root !");
        return null;
    }

    public static IFile toIFile(String absoluteFilePath) {
        return EclipseWksUtil.toIFile(new File(absoluteFilePath));
    }

    public static IFile toIFile(File file) {
        EclipseWksUtil.log("toIFile( File ) : file = " + file.getAbsolutePath());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root != null) {
            String sAbsolutePath = file.getAbsolutePath();
            Path path = new Path(sAbsolutePath);
            IFile iFile = root.getFileForLocation((IPath)path);
            if (iFile != null) {
                return iFile;
            }
            return null;
        }
        return null;
    }

    public static String getAbsolutePath(IFile iFile) {
        File file = EclipseWksUtil.toFile(iFile);
        return file.getAbsolutePath();
    }

    public static File toFile(IFile iFile) {
        String workspaceLocation = EclipseWksUtil.getWorkspaceLocation();
        String fileFullPathInworkspace = iFile.getFullPath().toString();
        String fileAbsolutePath = FileUtil.buildFilePath((String)workspaceLocation, (String)fileFullPathInworkspace);
        return new File(fileAbsolutePath);
    }

    public static void refresh(File file) {
        EclipseWksUtil.log("refresh( File ) ");
        if (file == null) {
            MsgBox.error("refresh(File) : parameter is null !");
            return;
        }
        if (file.isDirectory()) {
            IFolder iFolder = EclipseWksUtil.toIFolder(file);
            if (iFolder != null) {
                EclipseWksUtil.log("refreshing IFolder = " + iFolder);
                try {
                    iFolder.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    throw new RuntimeException("Cannot refresh folder", e);
                }
            }
        } else {
            EclipseWksUtil.refresh(EclipseWksUtil.toIFile(file));
        }
    }

    public static void refresh(IFile iFile) {
        if (iFile != null) {
            EclipseWksUtil.log("refreshing IFile = " + iFile);
            try {
                iFile.refreshLocal(0, null);
            }
            catch (CoreException e) {
                throw new RuntimeException("Cannot refresh file", e);
            }
        }
    }

    public static boolean setBuildAutomatically(boolean flag) {
        IWorkspace workspace = EclipseWksUtil.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean originalFlag = desc.isAutoBuilding();
        desc.setAutoBuilding(flag);
        try {
            workspace.setDescription(desc);
        }
        catch (CoreException e) {
            MsgBox.error("setBuildAutomatically : Cannot set workspace description ", e);
        }
        return originalFlag;
    }
}

