/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.telosys.tools.commons.FileUtil;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.bundles.TargetDefinition;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.config.ProjectConfigManager;

public class FileEditorUtil {
    private static final String VELOCITY_EDITOR_ID = "org.telosys.tools.eclipse.plugin.editors.velocity.VelocityEditor";
    private static final String DSL_ENTITY_EDITOR_ID = "org.telosys.tools.eclipse.plugin.editors.dsl.entityEditor.EntityEditor";
    private static final String DSL_MODEL_EDITOR_ID = "org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditor";
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    private static void log(String s) {
        PluginLogger.log(String.valueOf(FileEditorUtil.class.getName()) + " : " + s);
    }

    private static String getFilePathFromTemplatesFolder(IProject project, String bundleName, String fileName) {
        FileEditorUtil.log("getFilePathFromTemplatesFolder(.., " + bundleName + ", " + fileName + ")");
        TelosysToolsCfg telosysToolsCfg = ProjectConfigManager.loadProjectConfig(project);
        if (telosysToolsCfg != null) {
            String folder = telosysToolsCfg.getTemplatesFolderAbsolutePath();
            if (!StrUtil.nullOrVoid((String)bundleName)) {
                folder = telosysToolsCfg.getTemplatesFolderAbsolutePath(bundleName);
            }
            String templateFile = FileUtil.buildFilePath((String)folder, (String)fileName);
            FileEditorUtil.log("Template file full path = " + templateFile);
            return templateFile;
        }
        return null;
    }

    public static void openTemplateFileInEditor(IProject project, String bundleName, TargetDefinition target) {
        FileEditorUtil.log("openTemplateFileInEditor(.., " + bundleName + ", " + target.getTemplate() + ")");
        String absoluteFilePath = FileEditorUtil.getFilePathFromTemplatesFolder(project, bundleName, target.getTemplate());
        FileEditorUtil.openFileInEditor(absoluteFilePath, VELOCITY_EDITOR_ID);
    }

    public static void openTargetsConfigFileInEditor(IProject project, String bundleName) {
        FileEditorUtil.log("openTargetsConfigFileInEditor(.., " + bundleName + ")");
        String absoluteFilePath = FileEditorUtil.getFilePathFromTemplatesFolder(project, bundleName, "templates.cfg");
        FileEditorUtil.openFileInEditor(absoluteFilePath, DEFAULT_TEXT_EDITOR_ID);
    }

    public static void openEntityFileInEditor(String entityAbsoluteFilePath) {
        FileEditorUtil.log("openEntityFileInEditor(.., " + entityAbsoluteFilePath + ")");
        FileEditorUtil.openFileInEditor(entityAbsoluteFilePath, DSL_ENTITY_EDITOR_ID);
    }

    public static void openModelFileInEditor(String modelAbsoluteFilePath) {
        FileEditorUtil.log("openModelFileInEditor(.., " + modelAbsoluteFilePath + ")");
        FileEditorUtil.openFileInEditor(modelAbsoluteFilePath, DSL_MODEL_EDITOR_ID);
    }

    private static void openFileInEditor(String absoluteFilePath, String editorId) {
        IFile iFile = EclipseWksUtil.toIFile(absoluteFilePath);
        if (iFile != null) {
            FileEditorInput editorInput = new FileEditorInput(iFile);
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            try {
                workbenchPage.openEditor((IEditorInput)editorInput, editorId);
            }
            catch (PartInitException partInitException) {
                MsgBox.error("Cannot open file in editor (PartInitException)");
            }
        } else {
            MsgBox.error("Cannot open file in editor \nFile '" + absoluteFilePath + "' \n " + "is not under the location of any existing project in the workspace. \n");
        }
    }
}

