/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.commons;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Util {
    private static final Cursor CURSOR_WAIT = new Cursor(null, 1);
    private static final Cursor CURSOR_ARROW = new Cursor(null, 0);

    public static Shell getActiveWindowShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Shell cursorWait() {
        Shell shell = Util.getActiveWindowShell();
        Util.cursorWait(shell);
        return shell;
    }

    public static void cursorWait(Shell shell) {
        if (shell != null) {
            shell.setCursor(CURSOR_WAIT);
        }
    }

    public static Shell cursorArrow() {
        Shell shell = Util.getActiveWindowShell();
        Util.cursorArrow(shell);
        return shell;
    }

    public static void cursorArrow(Shell shell) {
        if (shell != null) {
            shell.setCursor(CURSOR_ARROW);
        }
    }

    private static Font getPageTitleFont(Device device) {
        FontData fontData = new FontData();
        fontData.setName("Arial");
        fontData.setHeight(12);
        Font font = new Font(device, fontData);
        return font;
    }

    private static Color getPageTitleColor(Device device) {
        Color color = new Color(device, 10, 36, 106);
        return color;
    }

    public static Label setPageTitle(Composite composite, String text) {
        Display device = composite.getDisplay();
        Font font = Util.getPageTitleFont((Device)device);
        Color color = Util.getPageTitleColor((Device)device);
        Label label = new Label(composite, 0);
        label.setText(text);
        label.setForeground(color);
        label.setFont(font);
        return label;
    }

    public static void launchExternalBrowser(String url) {
        Program.launch((String)url);
    }
}

