/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.config;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.cfg.TelosysToolsCfgManager;
import org.telosys.tools.commons.variables.Variable;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class ProjectConfigManager {
    public static TelosysToolsCfg loadProjectConfig(IProject project) {
        if (project == null) {
            MsgBox.error("ProjectConfigManager : loadProjectConfig : project is null");
        }
        String projectName = ProjectConfigManager.getProjectName(project);
        String projectFolder = EclipseProjUtil.getProjectDir(project);
        PluginLogger.log("ProjectConfigManager.loadProjectConfig(" + projectFolder + ")...");
        TelosysToolsCfgManager telosysToolsCfgManager = new TelosysToolsCfgManager(projectFolder);
        TelosysToolsCfg telosysToolsCfg = null;
        try {
            telosysToolsCfg = telosysToolsCfgManager.loadTelosysToolsCfg();
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot load TelosysTools configuration", e);
            telosysToolsCfg = telosysToolsCfgManager.createDefaultTelosysToolsCfg();
        }
        if (!telosysToolsCfg.hasBeenInitializedFromFile()) {
            LinkedList<Variable> vars = new LinkedList<Variable>();
            vars.add(new Variable("MAVEN_ARTIFACT_ID", projectName));
            vars.add(new Variable("MAVEN_GROUP_ID", "group.to.be.defined"));
            vars.add(new Variable("PROJECT_NAME", projectName));
            vars.add(new Variable("PROJECT_VERSION", "0.1"));
            telosysToolsCfg.setSpecificVariables(vars);
        }
        return telosysToolsCfg;
    }

    public static void saveProjectConfig(IProject project, TelosysToolsCfg telosysToolsCfg) {
        String projectFolder = EclipseProjUtil.getProjectDir(project);
        PluginLogger.log("ProjectConfigManager.saveProjectConfig(" + projectFolder + ", properties)...");
        TelosysToolsCfgManager cfgManager = new TelosysToolsCfgManager(projectFolder);
        try {
            cfgManager.saveTelosysToolsCfg(telosysToolsCfg);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot save configuration", e);
        }
        String cfgFileAbsolutePath = cfgManager.getCfgFileAbsolutePath();
        File file = new File(cfgFileAbsolutePath);
        if (file.exists()) {
            EclipseWksUtil.refresh(file);
        } else {
            MsgBox.error("Cannot refresh file \n'" + cfgFileAbsolutePath + "' \n" + "This file doesn't exist");
        }
    }

    private static String getProjectName(IProject project) {
        if (project != null) {
            return project.getName();
        }
        return "unknown";
    }
}

