/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.config.view;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.commons.bundles.BundleStatus;
import org.telosys.tools.commons.bundles.BundlesManager;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.TelosysPluginException;

public class DownloadTaskWithProgress
implements IRunnableWithProgress {
    private final String user;
    private final String[] repoNames;
    private final Text loggerTextArea;
    private final boolean bInstall;
    private final TelosysToolsCfg telosysToolsCfg;
    private int _result = 0;

    public DownloadTaskWithProgress(TelosysToolsCfg telosysToolsCfg, String user, String[] repoNames, boolean bInstall, Text loggerTextArea) throws TelosysPluginException {
        this.telosysToolsCfg = telosysToolsCfg;
        this.user = user;
        this.repoNames = repoNames;
        this.bInstall = bInstall;
        this.loggerTextArea = loggerTextArea;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int count = 0;
        if (this.repoNames.length > 0) {
            BundlesManager bm = new BundlesManager(this.telosysToolsCfg);
            int totalWorkTasks = this.repoNames.length;
            progressMonitor.beginTask("Download in progress", totalWorkTasks + 1);
            progressMonitor.worked(1);
            this.loggerTextArea.setText("");
            String[] stringArray = this.repoNames;
            int n = this.repoNames.length;
            int n2 = 0;
            while (n2 < n) {
                BundleStatus status;
                String githubRepoName = stringArray[n2];
                progressMonitor.subTask("Download #" + ++count + " '" + githubRepoName + "'");
                if (this.bInstall) {
                    this.loggerTextArea.append("-> #" + count + " Download & Install '" + githubRepoName + "' ... \n");
                    status = bm.downloadAndInstallBundle(this.user, githubRepoName);
                } else {
                    this.loggerTextArea.append("-> #" + count + " Download '" + githubRepoName + "' ... \n");
                    status = bm.downloadBundle(this.user, githubRepoName);
                }
                if (status.isDone()) {
                    this.loggerTextArea.append("OK, done. \n");
                } else {
                    this.loggerTextArea.append(String.valueOf(status.getMessage()) + "\n");
                    if (status.getException() != null) {
                        this.loggerTextArea.append("Exception : " + status.getException() + "\n");
                    }
                }
                EclipseWksUtil.refresh(new File(bm.getDownloadsFolderFullPath()));
                if (this.bInstall) {
                    EclipseWksUtil.refresh(new File(this.telosysToolsCfg.getTemplatesFolderAbsolutePath()));
                }
                progressMonitor.worked(1);
                this.loggerTextArea.append("\n");
                ++n2;
            }
        }
        progressMonitor.done();
        if (progressMonitor.isCanceled()) {
            throw new InterruptedException("The download was cancelled");
        }
        this._result = count;
    }

    public int getResult() {
        return this._result;
    }
}

