/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.config.view;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.telosys.tools.commons.bundles.BundlesManager;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

public class PopulateListTaskWithProgress
implements IRunnableWithProgress {
    private final String userName;
    private final org.eclipse.swt.widgets.List swtListOfBundles;
    private final TelosysToolsCfg telosysToolsCfg;

    public PopulateListTaskWithProgress(TelosysToolsCfg telosysToolsCfg, String sGitHubUserName, org.eclipse.swt.widgets.List swtListToBePopulated) {
        this.telosysToolsCfg = telosysToolsCfg;
        this.userName = sGitHubUserName;
        this.swtListOfBundles = swtListToBePopulated;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        int totalWorkTasks = 3;
        progressMonitor.beginTask("Requesting GitHub server ...", totalWorkTasks);
        progressMonitor.worked(1);
        this.swtListOfBundles.removeAll();
        BundlesManager bm = new BundlesManager(this.telosysToolsCfg);
        List bundles = null;
        try {
            bundles = bm.getGitHubBundlesList(this.userName);
        }
        catch (Exception e1) {
            MsgBox.error("Cannot get bundles from GitHub", e1);
        }
        progressMonitor.worked(1);
        if (bundles != null) {
            for (String s : bundles) {
                this.swtListOfBundles.add(s);
            }
        }
        progressMonitor.done();
    }
}

