/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.config.view;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.telosys.tools.commons.DirUtil;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.env.EnvironmentManager;
import org.telosys.tools.commons.env.TelosysToolsEnv;
import org.telosys.tools.commons.http.HttpUtil;
import org.telosys.tools.commons.variables.Variable;
import org.telosys.tools.eclipse.plugin.MyPlugin;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.commons.TelosysPluginException;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.commons.dialogbox.FolderSelectionDialogBox;
import org.telosys.tools.eclipse.plugin.config.ProjectConfigManager;
import org.telosys.tools.eclipse.plugin.config.view.DownloadTaskWithProgress;
import org.telosys.tools.eclipse.plugin.config.view.InitButtonSelectionListener;
import org.telosys.tools.eclipse.plugin.config.view.LinkSelectionListener;
import org.telosys.tools.eclipse.plugin.config.view.PopulateListTaskWithProgress;
import org.telosys.tools.eclipse.plugin.config.view.VariablesTable;
import org.telosys.tools.eclipse.plugin.settings.SettingsManager;
import org.telosys.tools.generator.context.names.ContextNames;

public class PropertiesPage
extends PropertyPage {
    private static final boolean DEBUG_MODE = false;
    private static final String WEB_CONTENT = "WebContent";
    private static final String DEFAULT_GITHUB_USER_NAME = "telosys-templates-v3";
    private Composite _pageComposite;
    private Composite _panelNotInitialized;
    private Text _tSrcFolder = null;
    private Text _tResFolder = null;
    private Text _tWebFolder = null;
    private Text _tTestSrcFolder = null;
    private Text _tTestResFolder = null;
    private Text _tDocFolder = null;
    private Text _tTmpFolder = null;
    private Text _tEntityPackage = null;
    private Text _tRootPackage = null;
    private Text _tGitHubUserName = null;
    private org.eclipse.swt.widgets.List _listGitHubRepositories = null;
    private Button _checkBoxUnzipDownload = null;
    private Text _tLogger = null;
    private Text _tProjectName = null;
    private Text _tProjectLocation = null;
    private Text _tWorkspaceLocation = null;
    private Text _tPluginConfigFile = null;
    private Text _tModelsFolder = null;
    private Text _tDownloadsFolder = null;
    private Text _tLibrariesFolder = null;
    private Text _tTemplatesFolder = null;
    private Text _tDestinationFolder = null;
    private VariablesTable _variablesTable = null;
    private Button _rbTemplatesFolderStandard;
    private Button _rbTemplatesFolderWorkspace;
    private Button _rbTemplatesFolderFilesystem;
    private Link _linkTemplatesFolderBrowse;
    private Text _tSpecificTemplatesFolder;
    private Button _rbDestinationFolderStandard;
    private Button _rbDestinationFolderFilesystem;
    private Link _linkDestinationFolderBrowse;
    private Text _tSpecificDestinationFolder;

    private void log(String s) {
        PluginLogger.log(s);
    }

    private void createTabAdvancedTemplatesFolderGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)this.getColSpan(5));
        group.setText("Templates bundles folder location");
        group.setLayout((Layout)new GridLayout(2, false));
        this._rbTemplatesFolderStandard = new Button((Composite)group, 16);
        this._rbTemplatesFolderStandard.setText("Standard location : '" + TelosysToolsEnv.getInstance().getTemplatesFolder() + "' in the current project ");
        this._rbTemplatesFolderStandard.setLayoutData((Object)this.getColSpan(2));
        this._rbTemplatesFolderWorkspace = new Button((Composite)group, 16);
        this._rbTemplatesFolderWorkspace.setText("Specific location : this current workspace (each bundle is a project)");
        this._rbTemplatesFolderWorkspace.setLayoutData((Object)this.getColSpan(2));
        this._rbTemplatesFolderFilesystem = new Button((Composite)group, 16);
        this._rbTemplatesFolderFilesystem.setText("Specific location : a folder somewhere in the filesystem ");
        this._rbTemplatesFolderFilesystem.setData((Object)"");
        this._linkTemplatesFolderBrowse = new Link((Composite)group, 0);
        this._linkTemplatesFolderBrowse.setText("<A>Browse to select a folder...</A>");
        this._linkTemplatesFolderBrowse.setEnabled(false);
        this._tSpecificTemplatesFolder = new Text((Composite)group, 2048);
        this._tSpecificTemplatesFolder.setLayoutData((Object)this.getColSpan(2));
        this._tSpecificTemplatesFolder.setEditable(false);
        this._linkTemplatesFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String folder = FolderSelectionDialogBox.chooseFolder(PropertiesPage.this._linkTemplatesFolderBrowse.getShell(), "Select templates folder");
                if (folder != null) {
                    PropertiesPage.this._tSpecificTemplatesFolder.setText(folder);
                    PropertiesPage.this._rbTemplatesFolderFilesystem.setData((Object)folder);
                }
            }
        });
        this._rbTemplatesFolderStandard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesPage.this._linkTemplatesFolderBrowse.setEnabled(false);
                PropertiesPage.this._tSpecificTemplatesFolder.setText("");
            }
        });
        this._rbTemplatesFolderWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesPage.this._linkTemplatesFolderBrowse.setEnabled(false);
                PropertiesPage.this._tSpecificTemplatesFolder.setText(PropertiesPage.this.getCurrentWorkspaceAbsolutePath());
            }
        });
        this._rbTemplatesFolderFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesPage.this._tSpecificTemplatesFolder.setText((String)PropertiesPage.this._rbTemplatesFolderFilesystem.getData());
                PropertiesPage.this._linkTemplatesFolderBrowse.setEnabled(true);
            }
        });
    }

    private void createTabAdvancedDestinationFolderGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)this.getColSpan(5));
        group.setText("Destination folder location for code generation");
        group.setLayout((Layout)new GridLayout(2, false));
        this._rbDestinationFolderStandard = new Button((Composite)group, 16);
        this._rbDestinationFolderStandard.setText("Standard location : the current project ");
        this._rbDestinationFolderStandard.setLayoutData((Object)this.getColSpan(2));
        this._rbDestinationFolderFilesystem = new Button((Composite)group, 16);
        this._rbDestinationFolderFilesystem.setText("Specific location : a folder somewhere in the filesystem ");
        this._rbDestinationFolderFilesystem.setData((Object)"");
        this._linkDestinationFolderBrowse = new Link((Composite)group, 0);
        this._linkDestinationFolderBrowse.setText("<A>Browse to select a folder...</A>");
        this._linkDestinationFolderBrowse.setEnabled(false);
        this._tSpecificDestinationFolder = new Text((Composite)group, 2048);
        this._tSpecificDestinationFolder.setLayoutData((Object)this.getColSpan(2));
        this._tSpecificDestinationFolder.setEditable(false);
        this._tSpecificDestinationFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                PluginLogger.log("Text modified");
            }
        });
        this._linkDestinationFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String folder = FolderSelectionDialogBox.chooseFolder(PropertiesPage.this._linkDestinationFolderBrowse.getShell(), "Select generation destination folder");
                if (folder != null) {
                    PropertiesPage.this._tSpecificDestinationFolder.setText(folder);
                    PropertiesPage.this._rbDestinationFolderFilesystem.setData((Object)folder);
                }
            }
        });
        this._rbDestinationFolderStandard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesPage.this._linkDestinationFolderBrowse.setEnabled(false);
                PropertiesPage.this._tSpecificDestinationFolder.setText("");
            }
        });
        this._rbDestinationFolderFilesystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PropertiesPage.this._tSpecificDestinationFolder.setText((String)PropertiesPage.this._rbDestinationFolderFilesystem.getData());
                PropertiesPage.this._linkDestinationFolderBrowse.setEnabled(true);
            }
        });
    }

    private boolean isProjectInitialized() {
        EnvironmentManager em = this.getEnvironmentManager();
        return em.isEnvironmentInitialized();
    }

    protected Control createContents(Composite parent) {
        IProject project = this.getCurrentProject();
        String projectName = project != null ? project.getName() : "?";
        this.setTitle("Telosys Tools configuration - Project \"" + projectName + "\"");
        try {
            this._pageComposite = new Composite(parent, 0);
            this._pageComposite.setLayout((Layout)new FillLayout());
            if (this.isProjectInitialized()) {
                this.createContentsStandardAndInitFields();
            } else {
                this.createContentsNotInitialized();
            }
        }
        catch (Exception e) {
            MsgBox.error("Error in createContents().", e);
        }
        return this._pageComposite;
    }

    private void createContentsStandardAndInitFields() {
        TabFolder tabFolder = new TabFolder(this._pageComposite, 0);
        this.createTabInfo(tabFolder);
        this.createTabFolders(tabFolder);
        this.createTabPackages(tabFolder);
        this.createTabVariables(tabFolder);
        this.createTabTemplates(tabFolder);
        this.createTabGeneral(tabFolder);
        this.createTabAdvanced(tabFolder);
        this.createTabAboutPlugin(tabFolder);
        this.configToFields(this.loadProjectConfig());
        this._pageComposite.layout();
    }

    private void createContentsNotInitialized() {
        Composite panel = new Composite(this._pageComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        panel.setLayout((Layout)gridLayout);
        Label voidLabel = new Label(panel, 0);
        voidLabel.setText("");
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 128;
        gd.minimumWidth = 600;
        gd.widthHint = 600;
        voidLabel.setLayoutData((Object)gd);
        new Label(panel, 0x1000000).setText("This project is not yet initialized for Telosys ");
        new Label(panel, 0x1000000).setText("Click on the following button to initialize the project :");
        Button initButton = new Button(panel, 8);
        initButton.setText("Initialize Telosys Tools");
        initButton.setToolTipText(" Creates the Telosys Tools folders \n and the databases configuration file \n if they don't exist");
        initButton.addSelectionListener((SelectionListener)new InitButtonSelectionListener(this));
        this._panelNotInitialized = panel;
    }

    private void createTabGeneral(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" General ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)tabContent);
        this._tProjectName = this.createTextField(tabContent, "Project name : ");
        this._tProjectName.setEditable(false);
        this._tWorkspaceLocation = this.createTextField(tabContent, "Workspace location :");
        this._tWorkspaceLocation.setEditable(false);
        this._tProjectLocation = this.createTextField(tabContent, "Project location :");
        this._tProjectLocation.setEditable(false);
        this._tPluginConfigFile = this.createTextField(tabContent, "Project config file : ");
        this._tPluginConfigFile.setEditable(false);
        this._tModelsFolder = this.createTextField(tabContent, "Models folder :");
        this._tModelsFolder.setEditable(false);
        this._tDownloadsFolder = this.createTextField(tabContent, "Downloads folder :");
        this._tDownloadsFolder.setEditable(false);
        this._tLibrariesFolder = this.createTextField(tabContent, "Libraries folder :");
        this._tLibrariesFolder.setEditable(false);
        this._tTemplatesFolder = this.createTextField(tabContent, "Templates folder :");
        this._tTemplatesFolder.setEditable(false);
        this._tTemplatesFolder.setToolTipText("Templates bundles folder");
        this._tDestinationFolder = this.createTextField(tabContent, "Destination folder :");
        this._tDestinationFolder.setEditable(false);
        this._tDestinationFolder.setToolTipText("Destination folder for code generation");
    }

    protected void initializeProject() {
        this.initTelosysToolsEnv();
        this._panelNotInitialized.dispose();
        this.createContentsStandardAndInitFields();
    }

    private void initTelosysToolsEnv() {
        IProject currentProject = this.getCurrentProject();
        EnvironmentManager em = this.getEnvironmentManager();
        StringBuffer sb = new StringBuffer();
        sb.append("Project initialization \n");
        sb.append("\n");
        String projectName = currentProject.getName();
        LinkedList<Variable> specificVariables = new LinkedList<Variable>();
        specificVariables.add(new Variable("MAVEN_ARTIFACT_ID", projectName));
        specificVariables.add(new Variable("PROJECT_NAME", projectName));
        em.initEnvironment(sb, specificVariables);
        TelosysToolsEnv telosysToolsEnv = TelosysToolsEnv.getInstance();
        EclipseProjUtil.refreshFile(currentProject, telosysToolsEnv.getTelosysToolsConfigFileName());
        EclipseProjUtil.refreshFile(currentProject, telosysToolsEnv.getDatabasesDbCfgFilePath());
        EclipseProjUtil.refreshFolder(currentProject, telosysToolsEnv.getTelosysToolsFolder());
        EclipseProjUtil.refreshFolder(currentProject, telosysToolsEnv.getDownloadsFolder());
        EclipseProjUtil.refreshFolder(currentProject, telosysToolsEnv.getLibrariesFolder());
        EclipseProjUtil.refreshFolder(currentProject, telosysToolsEnv.getTemplatesFolder());
        MsgBox.info(sb.toString());
    }

    private void createTabPackages(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Packages ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)tabContent);
        this.createSingleLabel(tabContent, "Define here the standard packages variables (usable in targets and templates)", 3);
        this.createSingleLabel(tabContent, "If you need more packages define them in \"Variables\" ", 3);
        this._tRootPackage = this.createTextField(tabContent, "Root package ", "${ROOT_PKG}");
        this._tEntityPackage = this.createTextField(tabContent, "Entity classes package ", "${ENTITY_PKG}");
    }

    private void createTabInfo(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Information ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(2, false));
        tabItem.setControl((Control)tabContent);
        this.createSingleLabel(tabContent, " ", 2);
        this.createSingleLabel(tabContent, "Telosys generator configuration main steps : ", 2);
        int index = 0;
        this.createTabInfoDescLink(tabContent, tabFolder, " - \"<A>Folders</A>\" : ", "to configure the standard variables for project folders", ++index);
        this.createTabInfoDescLink(tabContent, tabFolder, " - \"<A>Packages</A>\" : ", "to configure the standard variables for project packages", ++index);
        this.createTabInfoDescLink(tabContent, tabFolder, " - \"<A>Variables</A>\" : ", "to configure the specific variables", ++index);
        this.createTabInfoDescLink(tabContent, tabFolder, " - \"<A>Templates</A>\" : ", "to download and install templates bundles", ++index);
        this.createSingleLabel(tabContent, " ", 2);
        this.createSingleLabel(tabContent, "Do not forget to click \"Apply\" to save the configuration ", 2);
        this.createSingleLabel(tabContent, " ", 2);
        this.createTabInfoHelpLink(tabContent, 2);
    }

    private void createTabInfoHelpLink(Composite composite, int colSpan) {
        this.createSingleLabel(composite, "For more information about Telosys : ", colSpan);
        Link link = new Link(composite, 0);
        link.setText(" - Telosys web site : <A>www.telosys.org</A>");
        link.setLayoutData((Object)this.getColSpan(colSpan));
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Util.launchExternalBrowser("http://www.telosys.org/");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        link = new Link(composite, 0);
        link.setText(" - Telosys on Twitter : <A>@telosys</A>");
        link.setLayoutData((Object)this.getColSpan(colSpan));
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Util.launchExternalBrowser("https://twitter.com/telosys");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolders(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Folders ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)tabContent);
        this.createSingleLabel(tabContent, "Define here the standard folders variables (usable in targets and templates)", 3);
        this.createSingleLabel(tabContent, "If you need more folders define them in \"Variables\" ", 3);
        this._tSrcFolder = this.createTextField(tabContent, "Sources", "${SRC}");
        this._tResFolder = this.createTextField(tabContent, "Resources ", "${RES}");
        this._tWebFolder = this.createTextField(tabContent, "Web content ", "${WEB}");
        this._tTestSrcFolder = this.createTextField(tabContent, "Tests sources  ", "${TEST_SRC}");
        this._tTestResFolder = this.createTextField(tabContent, "Tests resources ", "${TEST_RES}");
        this._tDocFolder = this.createTextField(tabContent, "Documentation", "${DOC}");
        this._tTmpFolder = this.createTextField(tabContent, "Temporary files", "${TMP}");
        this.createTabFoldersButtons(tabContent);
    }

    private void createTabVariables(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Variables ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(2, false));
        tabItem.setControl((Control)tabContent);
        Label label = new Label(tabContent, 16448);
        label.setFont(tabContent.getFont());
        label.setText("Define here your own specific variables (usable in targets and templates)");
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this._variablesTable = new VariablesTable(tabContent);
        GridData gdTable = new GridData();
        gdTable.heightHint = 300;
        gdTable.widthHint = 460;
        gdTable.horizontalAlignment = 1;
        gdTable.grabExcessHorizontalSpace = false;
        this._variablesTable.setLayoutData(gdTable);
        this.createTableButtons(tabContent, this._variablesTable);
        Button button = new Button(tabContent, 8);
        button.setText("Show reserved variable names");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                PropertiesPage.this.showReservedVariableNames();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private String repeat(char c, int n) {
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            chars[i] = c;
            ++i;
        }
        return new String(chars);
    }

    private String padRight(String s, int totalWidth, char paddingChar) {
        if (s.length() >= totalWidth) {
            return s;
        }
        return String.valueOf(s) + this.repeat(' ', totalWidth - s.length());
    }

    private boolean nameBreakNeeded(String previousName, String name) {
        return previousName.length() > 0 && name.length() > 0 && Character.isUpperCase(previousName.charAt(0)) && Character.isLowerCase(name.charAt(0));
    }

    private void showReservedVariableNames() {
        String[] reserverdNames = ContextNames.getSortedReservedNames();
        StringBuffer sb = new StringBuffer();
        sb.append("The following names are reserved : \n\n");
        int i = 0;
        String previousName = "";
        String[] stringArray = reserverdNames;
        int n = reserverdNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (this.nameBreakNeeded(previousName, name)) {
                sb.append("\n\n");
                i = 0;
            }
            if (++i % 2 == 0) {
                sb.append(name);
                sb.append(" \n");
            } else {
                sb.append(this.padRight(name, 18, ' '));
                sb.append("\t\t");
            }
            previousName = name;
            ++n2;
        }
        MsgBox.info(sb.toString());
    }

    private Composite createTableButtons(Composite composite, VariablesTable table) {
        RowLayout panelLayout = new RowLayout();
        panelLayout.type = 512;
        panelLayout.fill = true;
        panelLayout.pack = false;
        Composite panelBouton = new Composite(composite, 0);
        panelBouton.setLayout((Layout)panelLayout);
        Button button = null;
        button = new Button(panelBouton, 8);
        button.setText("Add");
        button.setToolTipText("Add an attribute at the end of the list");
        button.addSelectionListener((SelectionListener)table.getAddSelectionAdapter());
        button = new Button(panelBouton, 8);
        button.setText("Insert");
        button.setToolTipText("Insert an attribute");
        button.addSelectionListener((SelectionListener)table.getInsertSelectionAdapter());
        button = new Button(panelBouton, 8);
        button.setText("Delete");
        button.setToolTipText("Delete the selected attribute");
        button.addSelectionListener((SelectionListener)table.getDeleteSelectionAdapter());
        return panelBouton;
    }

    private void createTabTemplates(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Templates ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(2, false));
        tabItem.setControl((Control)tabContent);
        Label label = new Label(tabContent, 0);
        label.setText("Download templates bundles from GitHub (a 'bundle' is a set of templates and resources)");
        label.setLayoutData((Object)this.getColSpan(2));
        label = new Label(tabContent, 0);
        label.setText("");
        label.setLayoutData((Object)this.getColSpan(2));
        label = new Label(tabContent, 0);
        label.setText("GitHub user name : ");
        this._tGitHubUserName = new Text(tabContent, 2048);
        GridData gd = this.getCellGridData2();
        gd.widthHint = 400;
        this._tGitHubUserName.setLayoutData((Object)gd);
        this._tGitHubUserName.setText(DEFAULT_GITHUB_USER_NAME);
        label = new Label(tabContent, 0);
        label.setText("");
        Button b = new Button(tabContent, 8);
        b.setText("Get available bundles");
        b.setToolTipText(" Get available bundles \n from GitHub site ");
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                PropertiesPage.this.populateGitHubRepoList();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        label = new Label(tabContent, 0);
        label.setText("GitHub bundles : ");
        label.setLayoutData((Object)this.getCellGridData1());
        this._listGitHubRepositories = new org.eclipse.swt.widgets.List(tabContent, 2562);
        gd = this.getCellGridData2();
        gd.heightHint = 120;
        gd.widthHint = 390;
        this._listGitHubRepositories.setLayoutData((Object)gd);
        label = new Label(tabContent, 0);
        label.setText("");
        label.setLayoutData((Object)this.getCellGridData1());
        Composite composite1 = new Composite(tabContent, 0);
        GridLayout gdComposite = new GridLayout(2, false);
        gdComposite.marginLeft = 0;
        gdComposite.horizontalSpacing = 80;
        gdComposite.marginWidth = 0;
        composite1.setLayout((Layout)gdComposite);
        b = new Button(composite1, 8);
        b.setText("Download selected bundles(s)");
        b.setToolTipText(" Download selected bundle(s) \n from GitHub site ");
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (PropertiesPage.this._listGitHubRepositories.getSelectionCount() > 0) {
                    boolean bUnzip = PropertiesPage.this._checkBoxUnzipDownload.getSelection();
                    String[] selectedRepo = PropertiesPage.this._listGitHubRepositories.getSelection();
                    PropertiesPage.this.downloadSelectedFiles(selectedRepo, bUnzip);
                } else {
                    MsgBox.warning("Select at least one file");
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this._checkBoxUnzipDownload = new Button(composite1, 32);
        this._checkBoxUnzipDownload.setText("Install downloaded bundle(s)");
        this._checkBoxUnzipDownload.setSelection(true);
        label = new Label(tabContent, 0);
        label.setText("Log : ");
        label.setLayoutData((Object)this.getCellGridData1());
        this._tLogger = new Text(tabContent, 2562);
        gd = this.getCellGridData2();
        gd.widthHint = 390;
        gd.heightHint = 80;
        this._tLogger.setLayoutData((Object)gd);
        this._tLogger.setEditable(false);
        label = new Label(tabContent, 0);
        label.setText("If you experience download problems, check Eclipse proxy settings.");
        label.setLayoutData((Object)this.getColSpan(2));
    }

    private GridData getCellGridData1() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 128;
        return gd;
    }

    private GridData getCellGridData2() {
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 128;
        return gd;
    }

    private void populateGitHubRepoList() {
        String sGitHubUserName = this.getGitHubUserName();
        if (sGitHubUserName != null) {
            PopulateListTaskWithProgress task = new PopulateListTaskWithProgress(this.getTelosysToolsCfgFromFields(), sGitHubUserName, this._listGitHubRepositories);
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Util.getActiveWindowShell());
            try {
                progressMonitorDialog.run(false, false, (IRunnableWithProgress)task);
            }
            catch (InvocationTargetException e) {
                MsgBox.error("Error during task", e.getCause());
            }
            catch (InterruptedException interruptedException) {
                MsgBox.info("Task interrupted");
            }
            if (this._listGitHubRepositories.getItemCount() == 0) {
                MsgBox.info("No bundle available on GitHub '" + sGitHubUserName + "'");
            }
        }
    }

    private long downloadSelectedFiles(String[] repoNames, boolean bUnzip) {
        if (repoNames == null) {
            MsgBox.error("Selection is null !");
            return 0L;
        }
        TelosysToolsCfg telosysToolsCfg = this.getTelosysToolsCfgFromFields();
        if (telosysToolsCfg.hasSpecificTemplatesFolders()) {
            MsgBox.warning("A specific templates folder is currently defined. Donwload is not allowed");
            return 0L;
        }
        try {
            DirUtil.checkIsValidDirectory((String)telosysToolsCfg.getTemplatesFolderAbsolutePath());
        }
        catch (TelosysToolsException e) {
            MsgBox.warning("Templates folder" + e.getMessage());
            return 0L;
        }
        try {
            DirUtil.checkIsValidDirectory((String)telosysToolsCfg.getDownloadsFolderAbsolutePath());
        }
        catch (TelosysToolsException e) {
            MsgBox.warning("Download folder" + e.getMessage());
            return 0L;
        }
        DownloadTaskWithProgress task = null;
        try {
            task = new DownloadTaskWithProgress(telosysToolsCfg, this.getGitHubUserName(), repoNames, bUnzip, this._tLogger);
        }
        catch (TelosysPluginException e) {
            MsgBox.error("Cannot create DownloadTaskWithProgress instance", e);
            return 0L;
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Util.getActiveWindowShell());
        try {
            progressMonitorDialog.run(false, false, (IRunnableWithProgress)task);
        }
        catch (InvocationTargetException e) {
            MsgBox.error("Error during download", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            MsgBox.info("Download interrupted");
        }
        return task.getResult();
    }

    private String getGitHubUserName() {
        String user = this._tGitHubUserName.getText().trim();
        if (user.length() == 0) {
            MsgBox.warning("GitHub user name is void");
            return "";
        }
        return user;
    }

    private void createTabAdvanced(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Advanced ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(5, false));
        tabItem.setControl((Control)tabContent);
        this.createTabAdvancedTemplatesFolderGroup(tabContent);
        this.createTabAdvancedDestinationFolderGroup(tabContent);
    }

    private void createTabAboutPlugin(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" About plugin ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(3, false));
        tabItem.setControl((Control)tabContent);
        Text t = null;
        t = this.createTextField(tabContent, "Name :");
        t.setEditable(false);
        t.setText(MyPlugin.getName());
        t = this.createTextField(tabContent, "Version :");
        t.setEditable(false);
        t.setText(String.valueOf(MyPlugin.getVersion()) + " - " + "Plugin build 014 (#4)" + "  ( " + "2018-04-09" + " ) ");
        t = this.createTextField(tabContent, "Id :");
        t.setEditable(false);
        t.setText(MyPlugin.getId());
        t = this.createTextField(tabContent, "Directory URL :");
        t.setEditable(false);
        t.setText(MyPlugin.getBaseURLAsString());
        t = this.createTextField(tabContent, "Directory :");
        t.setEditable(false);
        t.setText(MyPlugin.getDirectory());
        t = this.createTextField(tabContent, "Resources dir :");
        t.setEditable(false);
        t.setText(MyPlugin.getResourcesDirectory());
        t = this.createTextField(tabContent, "Generator version :");
        t.setEditable(false);
        t.setText("3.0.0");
        t = this.createTextField(tabContent, "GitHub URL pattern :");
        t.setEditable(false);
        t.setText("https://github.com/${USER}/${REPO}/archive/master.zip");
        t = this.createTextArea(tabContent, "Http proxy config :");
        t.setEditable(false);
        t.setText(HttpUtil.getSystemProxyPropertiesAsString((String)"-----"));
    }

    private void createTabDebug(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Debug ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(2, false));
        tabItem.setControl((Control)tabContent);
        Label label = new Label(tabContent, 0);
        label.setText("Settings test 1 : ");
        new Label(tabContent, 0).setText("xxx");
        Button button = new Button(tabContent, 8);
        button.setText("isBundleStaticResourcesCopied");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsManager settingsManager = new SettingsManager(PropertiesPage.this.getCurrentProject());
                boolean r = settingsManager.readBundleStaticResourcesCopiedFlag("fakeBundle");
                MsgBox.info("Result = " + r);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(tabContent, 8);
        button.setText("setBundleStaticResourcesCopied");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsManager settingsManager = new SettingsManager(PropertiesPage.this.getCurrentProject());
                settingsManager.updateBundleStaticResourcesCopiedFlag("fakeBundle", true);
                MsgBox.info("Done (set to TRUE)");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFoldersButtons(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("");
        Label label2 = new Label(composite, 0);
        label2.setText("");
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new FillLayout());
        Button mavenButton = new Button(buttons, 8);
        mavenButton.setText("Maven project folders");
        mavenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                PropertiesPage.this._tSrcFolder.setText("src/main/java");
                PropertiesPage.this._tResFolder.setText("src/main/resources");
                PropertiesPage.this._tWebFolder.setText("src/main/webapp");
                PropertiesPage.this._tTestSrcFolder.setText("src/test/java");
                PropertiesPage.this._tTestResFolder.setText("src/test/resources");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button projectButton = new Button(buttons, 8);
        projectButton.setText("Eclipse project folders");
        projectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String srcWebContentFolderName;
                String srcFolderName = PropertiesPage.this.getProjectSourceFolder();
                if (StrUtil.nullOrVoid((String)srcFolderName)) {
                    srcFolderName = "src";
                }
                if (StrUtil.nullOrVoid((String)(srcWebContentFolderName = PropertiesPage.this.getProjectWebContentFolder()))) {
                    srcWebContentFolderName = String.valueOf(srcFolderName) + "-webapp";
                }
                PropertiesPage.this._tSrcFolder.setText(srcFolderName);
                PropertiesPage.this._tResFolder.setText(String.valueOf(srcFolderName) + "-resources");
                PropertiesPage.this._tWebFolder.setText(srcWebContentFolderName);
                PropertiesPage.this._tTestSrcFolder.setText(String.valueOf(srcFolderName) + "-test-java");
                PropertiesPage.this._tTestResFolder.setText(String.valueOf(srcFolderName) + "-test-resources");
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private String getProjectSourceFolder() {
        IProject project = this.getCurrentProject();
        if (!EclipseProjUtil.isJavaProject(project)) {
            return "";
        }
        String[] srcFolders = EclipseProjUtil.getSrcFolders(project);
        String projectSourceFolder = null;
        if (srcFolders.length == 1) {
            projectSourceFolder = srcFolders[0];
        } else if (srcFolders.length > 1) {
            String srcEquals = null;
            String srcStartsWith = null;
            String srcContains = null;
            String[] stringArray = srcFolders;
            int n = srcFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String srcFolder = stringArray[n2];
                if ("src".equals(srcFolder)) {
                    srcEquals = srcFolder;
                }
                if (srcFolder.startsWith("src") && srcStartsWith == null) {
                    srcStartsWith = srcFolder;
                }
                if (srcFolder.contains("src") && srcContains == null) {
                    srcContains = srcFolder;
                }
                ++n2;
            }
            projectSourceFolder = srcEquals != null ? srcEquals : (srcStartsWith != null ? srcStartsWith : (srcContains != null ? srcContains : srcFolders[0]));
        }
        if (projectSourceFolder == null) {
            projectSourceFolder = "";
        }
        return projectSourceFolder;
    }

    private String getProjectWebContentFolder() {
        IProject project = this.getCurrentProject();
        IFolder folder = project.getFolder(WEB_CONTENT);
        if (folder.exists()) {
            return WEB_CONTENT;
        }
        return "";
    }

    private Text createTextField(Composite composite, String sLabel) {
        Label label = new Label(composite, 0);
        label.setText(sLabel);
        Text textField = new Text(composite, 2048);
        textField.setLayoutData((Object)this.getColSpan(2));
        return textField;
    }

    private Text createTextField(Composite composite, String label1, String label2) {
        Label label = new Label(composite, 0);
        label.setText(label1);
        label = new Label(composite, 0);
        label.setText(label2);
        Text textField = new Text(composite, 2048);
        textField.setLayoutData((Object)this.getColSpan(1));
        return textField;
    }

    private Text createTextArea(Composite composite, String sLabel) {
        Label label = new Label(composite, 0);
        label.setText(sLabel);
        Text textArea = new Text(composite, 2562);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 100;
        textArea.setLayoutData((Object)gd);
        return textArea;
    }

    private void createTabInfoDescLink(Composite composite, TabFolder tabFolder, String tabTitle, String tabDescription, int tabIndex) {
        Link link = new Link(composite, 0);
        link.setText(tabTitle);
        link.addSelectionListener((SelectionListener)new LinkSelectionListener(tabFolder, tabIndex));
        new Label(composite, 0).setText(tabDescription);
    }

    private Label createSingleLabel(Composite composite, String sLabel, int colSpan) {
        Label label = new Label(composite, 0);
        label.setText(sLabel);
        label.setLayoutData((Object)this.getColSpan(colSpan));
        return label;
    }

    private GridData getColSpan(int n) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = n;
        return gd;
    }

    private IProject getCurrentProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable == null) {
            MsgBox.error("Cannot get Adaptable element ");
            return null;
        }
        return (IProject)adaptable;
    }

    private String getCurrentWorkspaceAbsolutePath() {
        return EclipseProjUtil.getWorkspaceLocation(this.getCurrentProject());
    }

    private EnvironmentManager getEnvironmentManager() {
        IProject currentProject = this.getCurrentProject();
        String projectFolderFullPath = EclipseProjUtil.getProjectDir(currentProject);
        return new EnvironmentManager(projectFolderFullPath);
    }

    private TelosysToolsCfg loadProjectConfig() {
        this.log("loadProjectConfig()...");
        return ProjectConfigManager.loadProjectConfig(this.getCurrentProject());
    }

    private void saveProjectConfig(TelosysToolsCfg telosysToolsCfg) {
        this.log("saveProjectConfig()...");
        ProjectConfigManager.saveProjectConfig(this.getCurrentProject(), telosysToolsCfg);
    }

    protected void performApply() {
        try {
            TelosysToolsCfg telosysToolsCfg = this.loadProjectConfig();
            this.fieldsToConfig(telosysToolsCfg);
            this.saveProjectConfig(telosysToolsCfg);
            this.configToFieldsInGeneralTab(telosysToolsCfg);
        }
        catch (Exception e) {
            MsgBox.error("Cannot save properties.", e);
        }
    }

    protected void performDefaults() {
    }

    private void configToFieldsInGeneralTab(TelosysToolsCfg telosysToolsCfg) {
        IProject project = this.getCurrentProject();
        this._tProjectName.setText(project.getName());
        this._tProjectLocation.setText(telosysToolsCfg.getProjectAbsolutePath());
        String workspaceFolderFullPath = this.getCurrentWorkspaceAbsolutePath();
        this._tWorkspaceLocation.setText(workspaceFolderFullPath);
        this._tPluginConfigFile.setText(telosysToolsCfg.getCfgFileAbsolutePath());
        this._tModelsFolder.setText(telosysToolsCfg.getModelsFolderAbsolutePath());
        this._tDownloadsFolder.setText(telosysToolsCfg.getDownloadsFolderAbsolutePath());
        this._tLibrariesFolder.setText(telosysToolsCfg.getLibrariesFolderAbsolutePath());
        this._tTemplatesFolder.setText(telosysToolsCfg.getTemplatesFolderAbsolutePath());
        this._tDestinationFolder.setText(telosysToolsCfg.getDestinationFolderAbsolutePath());
    }

    private void configToFields(TelosysToolsCfg telosysToolsCfg) {
        this.log("propertiesToFields ...");
        this._tSrcFolder.setText(telosysToolsCfg.getSRC());
        this._tResFolder.setText(telosysToolsCfg.getRES());
        this._tWebFolder.setText(telosysToolsCfg.getWEB());
        this._tTestSrcFolder.setText(telosysToolsCfg.getTEST_SRC());
        this._tTestResFolder.setText(telosysToolsCfg.getTEST_RES());
        this._tDocFolder.setText(telosysToolsCfg.getDOC());
        this._tTmpFolder.setText(telosysToolsCfg.getTMP());
        this._tEntityPackage.setText(telosysToolsCfg.getEntityPackage());
        this._tRootPackage.setText(telosysToolsCfg.getRootPackage());
        Object[] items = telosysToolsCfg.getSpecificVariables();
        if (items != null) {
            this._variablesTable.initItems(items);
        }
        this.configToFieldsInGeneralTab(telosysToolsCfg);
        if (telosysToolsCfg.hasSpecificTemplatesFolders()) {
            String workspaceFolderFullPath = this.getCurrentWorkspaceAbsolutePath();
            String specificFolder = telosysToolsCfg.getSpecificTemplatesFolderAbsolutePath();
            this._tSpecificTemplatesFolder.setText(specificFolder);
            if (workspaceFolderFullPath.equals(specificFolder)) {
                this._rbTemplatesFolderWorkspace.setSelection(true);
            } else {
                this._rbTemplatesFolderFilesystem.setData((Object)specificFolder);
                this._rbTemplatesFolderFilesystem.setSelection(true);
                this._linkTemplatesFolderBrowse.setEnabled(true);
            }
        } else {
            this._rbTemplatesFolderStandard.setSelection(true);
            this._tSpecificTemplatesFolder.setText("");
        }
        if (telosysToolsCfg.hasSpecificDestinationFolder()) {
            String specificFolder = telosysToolsCfg.getSpecificDestinationFolder();
            this._tSpecificDestinationFolder.setText(specificFolder);
            this._rbDestinationFolderFilesystem.setData((Object)specificFolder);
            this._rbDestinationFolderFilesystem.setSelection(true);
            this._linkDestinationFolderBrowse.setEnabled(true);
        } else {
            this._tSpecificDestinationFolder.setText("");
            this._rbDestinationFolderStandard.setSelection(true);
        }
    }

    private void fieldsToConfig(TelosysToolsCfg telosysToolsCfg) {
        this.log("fieldsToConfig ...");
        telosysToolsCfg.setSRC(this._tSrcFolder.getText());
        telosysToolsCfg.setRES(this._tResFolder.getText());
        telosysToolsCfg.setWEB(this._tWebFolder.getText());
        telosysToolsCfg.setTEST_SRC(this._tTestSrcFolder.getText());
        telosysToolsCfg.setTEST_RES(this._tTestResFolder.getText());
        telosysToolsCfg.setDOC(this._tDocFolder.getText());
        telosysToolsCfg.setTMP(this._tTmpFolder.getText());
        telosysToolsCfg.setRootPackage(this._tRootPackage.getText());
        telosysToolsCfg.setEntityPackage(this._tEntityPackage.getText());
        this.log("fieldsToConfig : variables ...");
        List<Variable> variables = this.getVariablesFromView();
        if (this.checkVariablesNames(variables)) {
            telosysToolsCfg.setSpecificVariables(variables);
            this.log("fieldsToConfig : " + variables.size() + " variable(s) set in TelosysToolsCfg");
        }
        if (this._rbTemplatesFolderStandard.getSelection()) {
            telosysToolsCfg.setSpecificTemplatesFolderAbsolutePath("");
        } else {
            telosysToolsCfg.setSpecificTemplatesFolderAbsolutePath(this._tSpecificTemplatesFolder.getText());
        }
        if (this._rbDestinationFolderStandard.getSelection()) {
            telosysToolsCfg.setSpecificDestinationFolder("");
        } else {
            telosysToolsCfg.setSpecificDestinationFolder(this._tSpecificDestinationFolder.getText());
        }
        this.log("fieldsToConfig : END");
    }

    private TelosysToolsCfg getTelosysToolsCfgFromFields() {
        TelosysToolsCfg telosysToolsCfg = this.loadProjectConfig();
        this.fieldsToConfig(telosysToolsCfg);
        return telosysToolsCfg;
    }

    private List<Variable> getVariablesFromView() {
        Object[] items = this._variablesTable.getItems();
        LinkedList<Variable> variables = new LinkedList<Variable>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof Variable) {
                variables.add((Variable)item);
            } else {
                MsgBox.error("Item from variables list is not an instance of 'Variable'");
            }
            ++n2;
        }
        return variables;
    }

    private boolean checkVariablesNames(List<Variable> variables) {
        List invalidNames = ContextNames.getInvalidVariableNames(variables);
        if (invalidNames != null) {
            StringBuffer sb = new StringBuffer();
            for (String variableName : invalidNames) {
                sb.append(" '" + variableName + "' ");
            }
            MsgBox.error("Invalid variable name(s) : " + sb.toString() + "\n These name(s) are reserved for 'standard variables'." + "\n The current variables will not be saved !");
            return false;
        }
        return true;
    }
}

