/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.console;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class TelosysConsole {
    private final MessageConsole console;
    private final MessageConsoleStream out;

    public TelosysConsole(String consoleName) {
        this.console = this.getConsole(consoleName);
        this.out = this.console.newMessageStream();
        PluginLogger.log("TelosysConsole created");
    }

    private MessageConsole getConsole(String consoleName) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] existingConsoles = consoleManager.getConsoles();
        int i = 0;
        while (i < existingConsoles.length) {
            if (consoleName.equals(existingConsoles[i].getName())) {
                return (MessageConsole)existingConsoles[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(consoleName, null);
        consoleManager.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public MessageConsoleStream getStream() {
        return this.out;
    }

    public void clear() {
        this.console.clearConsole();
    }

    public void print(String message) {
        this.out.print(message);
    }

    public void println(String message) {
        this.out.println(message);
    }

    public void reveal() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        try {
            IConsoleView view = (IConsoleView)workbenchPage.showView("org.eclipse.ui.console.ConsoleView");
            view.display((IConsole)this.console);
        }
        catch (PartInitException partInitException) {
            MsgBox.error("Cannot reveal the console (PartInitException)");
        }
    }
}

