/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.TelosysToolsLogger;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.cfg.TelosysToolsCfgManager;
import org.telosys.tools.commons.logger.ConsoleLogger;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public abstract class AbstractStandardEditor
extends FormEditor {
    private TelosysToolsLogger _logger = new ConsoleLogger();
    private IFile _iFile = null;
    private boolean _dirty = false;
    private boolean _bPopulateInProgress = false;

    public TelosysToolsLogger getLogger() {
        return this._logger;
    }

    protected void log(String s) {
        PluginLogger.log(s);
    }

    protected void log(Object o, String s) {
        PluginLogger.log(o, s);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.log((Object)this, "init(..,..) : site id = '" + site.getId() + "'");
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this._iFile = fileInput.getFile();
        } else {
            MsgBox.error("The editor input '" + input.getName() + "' is not a File ! ");
        }
    }

    public IProject getProject() {
        return this._iFile.getProject();
    }

    public String getProjectFolderAbsolutePath() {
        return EclipseProjUtil.getProjectDir(this.getProject());
    }

    public TelosysToolsCfg getProjectConfig() {
        TelosysToolsCfgManager cfgManager = new TelosysToolsCfgManager(this.getProjectFolderAbsolutePath());
        try {
            return cfgManager.loadTelosysToolsCfg();
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot load Telosys Tools configuration", e);
            return null;
        }
    }

    public String getShortFileName() {
        return this._iFile.getName();
    }

    public String getFileAbsolutePath() {
        return EclipseWksUtil.getAbsolutePath(this._iFile);
    }

    protected IFile getFile() {
        return this._iFile;
    }

    protected void refreshFile(IProgressMonitor monitor) {
        try {
            this._iFile.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot refresh file after save", e);
        }
    }

    public void setPopulateInProgress(boolean value) {
        this._bPopulateInProgress = value;
    }

    public boolean isPopulateInProgress() {
        return this._bPopulateInProgress;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty() {
        this.setDirty(true);
    }

    protected void setDirty(boolean flag) {
        if (this._dirty != flag) {
            this._dirty = flag;
            this.editorDirtyStateChanged();
        }
    }
}

