/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.commons;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;

public class SelectDeselectButtons {
    private Button selectAll;
    private Button deselectAll;

    public SelectDeselectButtons(Composite parent) {
        this.createButtonSelectAll(parent);
        this.createButtonDeselectAll(parent);
    }

    private void createButtonSelectAll(Composite panel) {
        this.selectAll = new Button(panel, 8);
        this.selectAll.setImage(PluginImages.getImage("CHECKED_ON"));
        this.selectAll.setToolTipText("Select All");
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                SelectDeselectButtons.this.setCheckedStateForAll((Table)button.getData(), true);
            }
        });
    }

    private void createButtonDeselectAll(Composite panel) {
        this.deselectAll = new Button(panel, 8);
        this.deselectAll.setImage(PluginImages.getImage("CHECKED_OFF"));
        this.deselectAll.setToolTipText("Deselect All");
        this.deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.getSource();
                SelectDeselectButtons.this.setCheckedStateForAll((Table)button.getData(), false);
            }
        });
    }

    public void setTable(Table managedTable) {
        this.selectAll.setData((Object)managedTable);
        this.deselectAll.setData((Object)managedTable);
    }

    private void setCheckedStateForAll(Table table, boolean flag) {
        if (table == null) {
            MsgBox.error("setCheckedForAll : managed table is null ");
            return;
        }
        try {
            int n = table.getItemCount();
            int i = 0;
            while (i < n) {
                TableItem item = table.getItem(i);
                item.setChecked(flag);
                ++i;
            }
        }
        catch (RuntimeException e1) {
            MsgBox.error("setCheckedForAll : " + e1.getMessage());
        }
    }
}

