/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbconfig;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.dbcfg.DatabasesConfigurations;
import org.telosys.tools.commons.dbcfg.DbConfigManager;
import org.telosys.tools.db.observer.DatabaseObserverProvider;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.console.DbMetadataObserver;
import org.telosys.tools.eclipse.plugin.console.DbModelObserver;
import org.telosys.tools.eclipse.plugin.editors.dbconfig.DbConfigEditorPage1;

public class DbConfigEditor
extends FormEditor {
    private boolean _dirty = false;
    private IFile _file = null;
    private DatabasesConfigurations databasesConfigurations = new DatabasesConfigurations();

    protected void addPages() {
        PluginLogger.log((Object)this, "addPages()...");
        DbConfigEditorPage1 page1 = new DbConfigEditorPage1(this, "DbConfigEditorPage1", " Database ");
        try {
            PluginLogger.log((Object)this, "addPages() : addPage(page1)");
            this.addPage((IFormPage)page1);
        }
        catch (Exception e) {
            MsgBox.error("addPage(page) Exception ", e);
        }
        PluginLogger.log((Object)this, "addPages() : all pages added ");
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            ((CTabFolder)container).setTabHeight(0);
        } else {
            MsgBox.error("addPages() : the container is not an instance of CTabFolder !");
        }
        PluginLogger.log((Object)this, "addPages() : end of method ");
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty() {
        this.setDirty(true);
    }

    private void setDirty(boolean flag) {
        this._dirty = flag;
        this.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        PluginLogger.log((Object)this, "doSave()...");
        monitor.beginTask("Saving the repository...", -1);
        DbConfigManager dbDonfigManager = new DbConfigManager(EclipseWksUtil.toFile(this._file));
        try {
            dbDonfigManager.save(this.databasesConfigurations);
            this.setDirty(false);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot save file.", e);
        }
        try {
            this._file.refreshLocal(0, monitor);
        }
        catch (CoreException e) {
            MsgBox.error("Cannot refresh the file after save." + (Object)((Object)e));
        }
        monitor.done();
    }

    public void doSaveAs() {
        PluginLogger.log((Object)this, "doSaveAs()...");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        DatabaseObserverProvider.setModelObserverClass(DbModelObserver.class);
        DatabaseObserverProvider.setMetadataObserverClass(DbMetadataObserver.class);
        PluginLogger.log((Object)this, "--- INIT ---");
        PluginLogger.log((Object)this, "init(..,..) : site id = '" + site.getId() + "'");
        PluginLogger.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
        this.setPartName(input.getName());
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this._file = fileInput.getFile();
            PluginLogger.log((Object)this, "init(..,..) : file name = '" + this._file.getName() + "'");
            try {
                DbConfigManager dbDonfigManager = new DbConfigManager(EclipseWksUtil.toFile(this._file));
                this.databasesConfigurations = dbDonfigManager.load();
                PluginLogger.log((Object)this, "init(..,..) : file loaded, " + this.databasesConfigurations.getNumberOfDatabases() + " db configuration(s).");
            }
            catch (TelosysToolsException e) {
                MsgBox.error("Cannot load databases configurations.", e);
            }
        } else {
            MsgBox.error("The editor input '" + input.getName() + "' is not a File ! ");
        }
    }

    public IFile getFile() {
        return this._file;
    }

    public IProject getProject() {
        return this._file.getProject();
    }

    public DatabasesConfigurations getDatabasesConfigurations() {
        return this.databasesConfigurations;
    }
}

