/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbconfig;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.telosys.tools.api.TelosysProject;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dbconfig.DbConfigEditor;

public abstract class DbConfigEditorPage
extends FormPage {
    private final DbConfigEditor _editor;

    public DbConfigEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this._editor = (DbConfigEditor)editor;
        if (this._editor == null) {
            MsgBox.error("Editor is null");
        }
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    protected IProject getProject() {
        return this._editor.getProject();
    }

    protected TelosysProject getTelosysProject() {
        IProject eclipseProject = this.getProject();
        if (eclipseProject != null) {
            String projectAbsolutePath = EclipseProjUtil.getProjectDir(eclipseProject);
            return new TelosysProject(projectAbsolutePath);
        }
        MsgBox.error("Invalid state : no project selected");
        return null;
    }

    protected DbConfigEditor getDbConfigEditor() {
        return this._editor;
    }

    protected void log(String s) {
        PluginLogger.log(s);
    }

    protected void log(Object o, String s) {
        PluginLogger.log(o, s);
    }

    protected void setDirty() {
        this._editor.setDirty();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.log((Object)this, "createFormContent(..)...");
        super.createFormContent(managedForm);
    }
}

