/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbconfig;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.api.MetaDataOptions;
import org.telosys.tools.api.MetaDataOptionsImpl;
import org.telosys.tools.api.TelosysProject;
import org.telosys.tools.commons.FileUtil;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.dbcfg.DatabaseConfiguration;
import org.telosys.tools.commons.dbcfg.DatabaseType;
import org.telosys.tools.commons.dbcfg.DatabasesConfigurations;
import org.telosys.tools.commons.dbcfg.DbConnectionStatus;
import org.telosys.tools.db.metadata.DbInfo;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginColors;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.commons.mapping.MapperTextBean;
import org.telosys.tools.eclipse.plugin.config.ProjectConfigManager;
import org.telosys.tools.eclipse.plugin.console.DbMetadataConsole;
import org.telosys.tools.eclipse.plugin.console.DbModelConsole;
import org.telosys.tools.eclipse.plugin.editors.dbconfig.DbConfigEditor;
import org.telosys.tools.eclipse.plugin.editors.dbconfig.DbConfigEditorPage;
import org.telosys.tools.eclipse.plugin.editors.dbconfig.DialogBoxNewDatabase;
import org.telosys.tools.repository.changelog.ChangeLog;

class DbConfigEditorPage1
extends DbConfigEditorPage {
    private static final String TEXT_DATA_MAPPER = "TEXT_DATA_MAPPER";
    private static final String TEXT_DATA_UPDATE_COMBO = "TEXT_DATA_UPDATE_COMBO";
    private static final int GROUP_X = 12;
    private static final int GET_NOTHING = 0;
    private static final int GET_COLUMNS = 1;
    private static final int GET_PRIMARY_KEYS = 2;
    private static final int GET_FOREIGN_KEYS = 3;
    private static final int GET_CATALOGS = 11;
    private static final int GET_SCHEMAS = 12;
    private DbConfigEditor _editor = null;
    private Combo _ComboDatabases = null;
    private Text _tId = null;
    private Text _tName = null;
    private Text _tDriver = null;
    private Text _tUrl = null;
    private Text _tUser = null;
    private Text _tPassword = null;
    private Text _tTypeName = null;
    private Text _tDialect = null;
    private Text _InfoURL = null;
    private Text _InfoProdName = null;
    private Text _InfoProdVer = null;
    private Text _InfoDriverName = null;
    private Text _InfoDriverVer = null;
    private Text _InfoMaxConn = null;
    private Text _InfoUser = null;
    private Text _InfoIsolation = null;
    private Text _InfoCatalogTerm = null;
    private Text _InfoCatalogSepar = null;
    private Text _InfoSchemaTerm = null;
    private Text _InfoSearchEscape = null;
    private Text _tMetaDataCatalog = null;
    private Text _tMetaDataSchema = null;
    private Text _tMetaDataTablePattern = null;
    private Text _tMetaDataTableTypes = null;
    private Text _tMetaDataTableInclude = null;
    private Text _tMetaDataTableExclude = null;
    private Text _tMetaData = null;
    private boolean _bPopulateInProgress = false;

    private void setBodyColor() {
        PluginColors.setStandardBackground(this.getManagedForm().getForm().getBody());
    }

    public DbConfigEditorPage1(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
        this._editor = (DbConfigEditor)editor;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..)...");
        this.log((Object)this, "init(..,..) : site id = '" + site.getId() + "'");
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(..)...");
        this.logInfo(managedForm);
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        RowLayout bodyLayout = new RowLayout(512);
        body.setLayout((Layout)bodyLayout);
        this.createFormHeader(body);
        Composite composite = null;
        composite = new Composite(body, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLocation(12, 100);
        composite.setSize(400, 200);
        TabFolder tabFolder = new TabFolder(composite, 0);
        this.createTabFolder1(tabFolder);
        this.createTabFolder2(tabFolder);
        this.createTabFolder3(tabFolder);
        this.log((Object)this, "Populate DATABASES combo ...");
        this.populateComboDatabases();
        this.selectFirstDatabaseInCombo();
        this.setBodyColor();
        this.log((Object)this, "Populate DATABASES combo : done.");
    }

    private void logInfo(IManagedForm managedForm) {
        Control pageControl = this.getPartControl();
        if (pageControl != null) {
            this.log((Object)this, "- getPartControl() != null ");
            if (pageControl instanceof Composite) {
                this.log((Object)this, "- pageControl is a Composite  ");
                this.log((Object)this, "- pageControl class = " + pageControl.getClass());
                Composite pageComposite = (Composite)pageControl;
                Layout layout = pageComposite.getLayout();
                this.log((Object)this, "- pageControl layout class = " + layout.getClass());
            } else {
                this.log((Object)this, "- pageControl() is NOT a Composite !!! ");
            }
        } else {
            this.log((Object)this, "- getPartControl() is null !!! ");
            return;
        }
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        this.log((Object)this, "- body class = " + body.getClass());
        Layout layout = body.getLayout();
        if (layout != null) {
            this.log((Object)this, "- body layout class = " + layout.getClass());
        } else {
            this.log((Object)this, "- body layout class = NO LAYOUT ! ");
        }
    }

    private void createFormHeader(Composite body) {
        Group group1 = new Group(body, 0);
        group1.setText("Database");
        group1.setLayout((Layout)new RowLayout());
        this._ComboDatabases = new Combo((Composite)group1, 2056);
        this._ComboDatabases.setVisibleItemCount(12);
        this._ComboDatabases.setLayoutData((Object)new RowData(240, -1));
        this.setDatabasesComboAction(this._ComboDatabases);
        Label filler = new Label((Composite)group1, 0);
        filler.setText("");
        filler.setLayoutData((Object)new RowData(10, -1));
        Button button = new Button((Composite)group1, 0);
        button.setText("New   ");
        button.setLayoutData((Object)new RowData(-1, -1));
        button.setImage(PluginImages.getImage("NEW_DATABASE"));
        button.setToolTipText("New database configuration");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionNewDatabase();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button((Composite)group1, 0);
        button.setText("Delete");
        button.setLayoutData((Object)new RowData(-1, -1));
        button.setImage(PluginImages.getImage("DELETE_DATABASE"));
        button.setToolTipText("Delete database configuration");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionDeleteDatabase();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        filler = new Label((Composite)group1, 0);
        filler.setText("");
        filler.setLayoutData((Object)new RowData(20, -1));
        button = new Button((Composite)group1, 0);
        button.setText("Create model");
        button.setLayoutData((Object)new RowData(-1, -1));
        button.setImage(PluginImages.getImage("GENERATE_REPO"));
        button.setToolTipText("Create a new database model");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionCreateNewDbModel();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button((Composite)group1, 0);
        button.setText("Update model");
        button.setLayoutData((Object)new RowData(-1, -1));
        button.setImage(PluginImages.getImage("UPDATE_REPO"));
        button.setToolTipText("Update existing database model");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionUpdateDbModel();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolder1(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolder1() ...");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("  Configuration  ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 12;
        tabContent.setLayout((Layout)gridLayout);
        this.createTabFolder1Panel1(tabContent);
        this.createTabFolder1Panel2(tabContent);
        tabItem.setControl((Control)tabContent);
    }

    private void createTabFolder1Panel1(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        gdPanel.widthHint = 540;
        Composite panel = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 12;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.widthHint = 540;
        this._tId = this.createTextWithLabel(panel, "Id", gd, false);
        this._tName = this.createTextWithLabel(panel, "Name", gd, true);
        this._tDriver = this.createTextWithLabel(panel, "Driver", gd, true);
        this._tUrl = this.createTextWithLabel(panel, "URL", gd, true);
        this._tUser = this.createTextWithLabel(panel, "User", gd, true);
        this._tPassword = this.createTextWithLabel(panel, "Password", gd, true);
        this._tTypeName = this.createTextWithLabel(panel, "Type ", gd, true);
        this._tDialect = this.createTextWithLabel(panel, "Dialect", gd, true);
        this.bindViewToModel(this._tId, "setDatabaseId", Integer.TYPE);
        this.bindViewToModel(this._tName, "setDatabaseName", String.class);
        this.bindViewToModel(this._tDriver, "setDriverClass", String.class);
        this.bindViewToModel(this._tUrl, "setJdbcUrl", String.class);
        this.bindViewToModel(this._tUser, "setUser", String.class);
        this.bindViewToModel(this._tPassword, "setPassword", String.class);
        this.bindViewToModel(this._tTypeName, "setTypeName", String.class);
        this.bindViewToModel(this._tDialect, "setDialect", String.class);
        this._tName.setData(TEXT_DATA_UPDATE_COMBO, (Object)"true");
    }

    private void createTabFolder1Panel2(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        Composite panel = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 12;
        gl.marginLeft = 20;
        panel.setLayout((Layout)gl);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 140;
        gd.verticalAlignment = 1;
        Button button = new Button(panel, 0);
        button.setText("Test connection");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionTestConnection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(panel, 0);
        button.setText("Show libraries");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.showLibraries();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolder2(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolder2() ...");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("  Information  ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 12;
        tabContent.setLayout((Layout)gridLayout);
        this.createTabFolder2Panel1(tabContent);
        this.createTabFolder2Panel2(tabContent);
        tabItem.setControl((Control)tabContent);
    }

    private void createTabFolder2Panel1(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        gdPanel.widthHint = 540;
        Composite panel = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 12;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 540;
        gd.verticalAlignment = 1;
        this._InfoProdName = this.createTextWithLabel(panel, "Product name", gd, true);
        this._InfoProdVer = this.createTextWithLabel(panel, "Product version", gd, true);
        this._InfoDriverName = this.createTextWithLabel(panel, "Driver name", gd, true);
        this._InfoDriverVer = this.createTextWithLabel(panel, "Driver version", gd, true);
        this._InfoURL = this.createTextWithLabel(panel, "JDBC URL", gd, true);
        this._InfoUser = this.createTextWithLabel(panel, "User name", gd, true);
        this._InfoIsolation = this.createTextWithLabel(panel, "Def. isolation level", gd, true);
        this._InfoMaxConn = this.createTextWithLabel(panel, "Max connections", gd, true);
        this._InfoCatalogTerm = this.createTextWithLabel(panel, "Catalog term", gd, true);
        this._InfoCatalogSepar = this.createTextWithLabel(panel, "Catalog separator", gd, true);
        this._InfoSchemaTerm = this.createTextWithLabel(panel, "Schema term", gd, true);
        this._InfoSearchEscape = this.createTextWithLabel(panel, "Search escape", gd, true);
        this._tName.setData(TEXT_DATA_UPDATE_COMBO, (Object)"true");
    }

    private void createTabFolder2Panel2(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        Composite panel = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 12;
        gl.marginLeft = 20;
        panel.setLayout((Layout)gl);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 150;
        gd.verticalAlignment = 1;
        Button button = new Button(panel, 0);
        button.setText("Get database info");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetInformations();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolder3(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolder3() ...");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("  Meta-data  ");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 12;
        tabContent.setLayout((Layout)gridLayout);
        this.createTabFolder3Fields(tabContent);
        tabItem.setControl((Control)tabContent);
    }

    private void createTabFolder3Panel1(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        gdPanel.widthHint = 400;
        Composite panel = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 12;
        panel.setLayout((Layout)gridLayout);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 260;
        gd.verticalAlignment = 1;
        this._tMetaDataCatalog = this.createTextWithLabel(panel, "Catalog ('!' for null) ", gd, true);
        this._tMetaDataSchema = this.createTextWithLabel(panel, "Schema ('!' for null) ", gd, true);
        this._tMetaDataTablePattern = this.createTextWithLabel(panel, "Table name pattern", gd, true);
        this._tMetaDataTableTypes = this.createTextWithLabel(panel, "Table types (separated by blanks)", gd, true);
        this._tMetaDataTableInclude = this.createTextWithLabel(panel, "Regex pattern to include tables", gd, true);
        this._tMetaDataTableExclude = this.createTextWithLabel(panel, "Regex pattern to exclude tables", gd, true);
        this.bindViewToModel(this._tMetaDataCatalog, "setMetadataCatalog", String.class);
        this.bindViewToModel(this._tMetaDataSchema, "setMetadataSchema", String.class);
        this.bindViewToModel(this._tMetaDataTablePattern, "setMetadataTableNamePattern", String.class);
        this.bindViewToModel(this._tMetaDataTableTypes, "setMetadataTableTypes", String.class);
        this.bindViewToModel(this._tMetaDataTableInclude, "setMetadataTableNameInclude", String.class);
        this.bindViewToModel(this._tMetaDataTableExclude, "setMetadataTableNameExclude", String.class);
    }

    private void createTabFolder3Panel2(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        Composite panel = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 12;
        gl.marginLeft = 20;
        panel.setLayout((Layout)gl);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 120;
        gd.verticalAlignment = 1;
        Button button = new Button(panel, 0);
        button.setText("Get tables");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(0);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(panel, 0);
        button.setText("Get columns");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(1);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(panel, 0);
        button.setText("Get primary keys");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(2);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(panel, 0);
        button.setText("Get foreign keys");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(3);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolder3Panel3(Composite container) {
        GridData gdPanel = new GridData();
        gdPanel.verticalAlignment = 1;
        Composite panel = new Composite(container, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 12;
        gl.marginLeft = 20;
        panel.setLayout((Layout)gl);
        panel.setLayoutData((Object)gdPanel);
        GridData gd = new GridData();
        gd.widthHint = 120;
        gd.verticalAlignment = 1;
        Button button = new Button(panel, 0);
        button.setText("Get catalogs");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(11);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        button = new Button(panel, 0);
        button.setText("Get schemas");
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                DbConfigEditorPage1.this.actionGetMetaData(12);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createTabFolder3Fields(Composite container) {
        this.createTabFolder3Panel1(container);
        this.createTabFolder3Panel2(container);
        this.createTabFolder3Panel3(container);
        GridData gd = new GridData();
        gd.widthHint = 700;
        gd.heightHint = 340;
        gd.horizontalSpan = 3;
        this._tMetaData = new Text(container, 2818);
        this._tMetaData.setLayoutData((Object)gd);
    }

    private Text createTextWithLabel(Composite container, String sLabel, GridData gridData, boolean b) {
        Label label = new Label(container, 0);
        label.setText(String.valueOf(sLabel) + " : ");
        Text text = new Text(container, 2048);
        text.setLayoutData((Object)gridData);
        text.setEnabled(b);
        return text;
    }

    private void populateComboDatabases() {
        DatabasesConfigurations databasesConfigurations = this._editor.getDatabasesConfigurations();
        if (databasesConfigurations != null) {
            if (this._ComboDatabases != null) {
                this._ComboDatabases.removeAll();
                List list = databasesConfigurations.getDatabaseConfigurationsList();
                this.log((Object)this, "loadComboBases() : nb bases = " + list.size());
                for (DatabaseConfiguration db : list) {
                    String sItem = String.valueOf(db.getDatabaseId()) + " - " + db.getDatabaseName();
                    this._ComboDatabases.add(sItem);
                    this.log((Object)this, "loadComboBases() : add " + sItem);
                }
            } else {
                MsgBox.error("populateDatabases : ComboBox is null !");
            }
        } else {
            MsgBox.error("populateDatabases : no db configurations ( null, file not loaded ) ");
        }
    }

    private void clearFields() {
        this._bPopulateInProgress = true;
        this._tId.setText("");
        this._tName.setText("");
        this._tDriver.setText("");
        this._tUrl.setText("");
        this._tUser.setText("");
        this._tPassword.setText("");
        this._tTypeName.setText("");
        this._tDialect.setText("");
        this._InfoURL.setText("");
        this._InfoProdName.setText("");
        this._InfoProdVer.setText("");
        this._InfoDriverName.setText("");
        this._InfoDriverVer.setText("");
        this._InfoMaxConn.setText("");
        this._InfoUser.setText("");
        this._InfoIsolation.setText("");
        this._InfoCatalogTerm.setText("");
        this._InfoCatalogSepar.setText("");
        this._InfoSchemaTerm.setText("");
        this._InfoSearchEscape.setText("");
        this._tMetaDataCatalog.setText("");
        this._tMetaDataSchema.setText("");
        this._tMetaDataTablePattern.setText("");
        this._tMetaDataTableTypes.setText("");
        this._tMetaDataTableInclude.setText("");
        this._tMetaDataTableExclude.setText("");
        this._tMetaData.setText("");
        this._bPopulateInProgress = false;
    }

    private String nn(String s) {
        return s != null ? s : "";
    }

    private void populateDatabaseConfigFields(int databaseId) {
        this.log((Object)this, "populateDatabaseConfigFields()");
        this._bPopulateInProgress = true;
        DatabasesConfigurations databasesConfigurations = this._editor.getDatabasesConfigurations();
        if (databasesConfigurations != null) {
            DatabaseConfiguration db = databasesConfigurations.getDatabaseConfiguration(databaseId);
            if (db != null) {
                this._tId.setText("" + db.getDatabaseId());
                this._tName.setText(this.nn(db.getDatabaseName()));
                this._tDriver.setText(this.nn(db.getDriverClass()));
                this._tUrl.setText(this.nn(db.getJdbcUrl()));
                this._tUser.setText(this.nn(db.getUser()));
                this._tPassword.setText(this.nn(db.getPassword()));
                this._tTypeName.setText(this.nn(db.getTypeName()));
                this._tDialect.setText(this.nn(db.getDialect()));
                this._tMetaDataCatalog.setText(this.nn(db.getMetadataCatalog()));
                this._tMetaDataSchema.setText(this.nn(db.getMetadataSchema()));
                this._tMetaDataTablePattern.setText(this.nn(db.getMetadataTableNamePattern()));
                this._tMetaDataTableTypes.setText(db.getMetadataTableTypes());
                this._tMetaDataTableInclude.setText(this.nn(db.getMetadataTableNameInclude()));
                this._tMetaDataTableExclude.setText(this.nn(db.getMetadataTableNameExclude()));
            } else {
                MsgBox.error("Database '" + databaseId + "' not found in the configuration.");
            }
        } else {
            MsgBox.error("Databases configurations not loaded.");
        }
        this._bPopulateInProgress = false;
    }

    private void setDatabasesComboAction(Combo combo) {
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo combo = (Combo)event.widget;
                DbConfigEditorPage1.this.populateDatabaseConfigFields(combo);
            }
        });
    }

    private int getSelectedDatabaseId(Combo databasesCombo, boolean required) {
        if (databasesCombo.getSelectionIndex() >= 0) {
            String s = databasesCombo.getText();
            if (s != null) {
                this.log((Object)this, "Database selected in combo : '" + s + "'");
                String[] parts = StrUtil.split((String)s, (char)'-');
                if (parts.length > 0) {
                    String sDbId = parts[0].trim();
                    int databaseId = this.databaseIdAsInt(sDbId);
                    return databaseId;
                }
                MsgBox.error("Invalid selected text in combobox");
            } else {
                MsgBox.error("Invalid selected text in combobox");
            }
        } else if (required) {
            MsgBox.warning("No database selected.");
        }
        return -99999;
    }

    private void populateDatabaseConfigFields(Combo databasesCombo) {
        int databaseId = this.getSelectedDatabaseId(databasesCombo, true);
        if (databaseId >= 0) {
            this.clearFields();
            this.populateDatabaseConfigFields(databaseId);
        }
    }

    private MapperTextBean<DatabaseConfiguration> getMapper(Text text) {
        Object o = text.getData(TEXT_DATA_MAPPER);
        return (MapperTextBean)o;
    }

    private void bindViewToModel(Text text, String setterMethodName, Class<?> setterMethodArgType) {
        MapperTextBean<DatabaseConfiguration> mapperInstance = new MapperTextBean<DatabaseConfiguration>(text, DatabaseConfiguration.class, setterMethodName, setterMethodArgType);
        text.setData(TEXT_DATA_MAPPER, mapperInstance);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!DbConfigEditorPage1.this._bPopulateInProgress && DbConfigEditorPage1.this._ComboDatabases.getSelectionIndex() >= 0) {
                    Text text = (Text)e.widget;
                    MapperTextBean mapper = DbConfigEditorPage1.this.getMapper(text);
                    DatabaseConfiguration currentDatabaseConfig = DbConfigEditorPage1.this.getCurrentDatabaseConfig(true);
                    if (currentDatabaseConfig != null) {
                        try {
                            mapper.updateBean(currentDatabaseConfig);
                            if (text.getData(DbConfigEditorPage1.TEXT_DATA_UPDATE_COMBO) != null) {
                                String s = String.valueOf(currentDatabaseConfig.getDatabaseId()) + " - " + currentDatabaseConfig.getDatabaseName();
                                int index = DbConfigEditorPage1.this._ComboDatabases.getSelectionIndex();
                                DbConfigEditorPage1.this._ComboDatabases.setItem(index, s);
                            }
                            DbConfigEditorPage1.this.setDirty();
                        }
                        catch (Exception e1) {
                            MsgBox.error("Cannot update the bean from the view", e1);
                        }
                    }
                }
            }
        });
    }

    private int databaseIdAsInt(String id) {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            MsgBox.error("Invalid database id '" + id + "'");
            return -9999;
        }
    }

    private DatabaseConfiguration getCurrentDatabaseConfig(boolean bConfigRequired) {
        DatabasesConfigurations databasesConfigurations = this._editor.getDatabasesConfigurations();
        if (databasesConfigurations != null) {
            int id = this.getSelectedDatabaseId(this._ComboDatabases, bConfigRequired);
            if (id >= 0) {
                DatabaseConfiguration db = databasesConfigurations.getDatabaseConfiguration(id);
                if (db != null) {
                    return db;
                }
                if (bConfigRequired) {
                    MsgBox.error("No database configuration for id '" + id + "'");
                }
                return null;
            }
        } else {
            MsgBox.error("No databases configuration file (file probably not loaded) ");
        }
        return null;
    }

    private String[] getLibraries() {
        this.log("getLibraries()");
        IProject project = this.getProject();
        this.log("getLibraries() : project name = '" + project.getName() + "' ");
        String[] librariesFromFolder = this.getLibrariesFromLibFolder(project);
        this.log("getLibraries() : librariesFromFolder.length = " + librariesFromFolder.length);
        if (EclipseProjUtil.isJavaProject(project)) {
            this.log("getLibraries() : Java project");
            String[] librariesFromJavaBuildPath = EclipseProjUtil.getClassPathLibraries(project);
            if (librariesFromJavaBuildPath != null) {
                this.log("getLibraries() : librariesFromJavaBuildPath.length = " + librariesFromJavaBuildPath.length);
                return this.combine(librariesFromFolder, librariesFromJavaBuildPath);
            }
            this.log("getLibraries() : No libraried from Java Build Path");
            return librariesFromFolder;
        }
        this.log("getLibraries() : Not a Java project");
        return librariesFromFolder;
    }

    private String[] combine(String[] a, String[] b) {
        this.log("combine(a[" + a.length + "), b[" + b.length + "])");
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private String[] getLibrariesFromLibFolder(IProject project) {
        this.log("getLibrariesFromFolder()");
        String[] voidLib = new String[]{};
        TelosysToolsCfg telosysToolsCfg = ProjectConfigManager.loadProjectConfig(project);
        String dir = telosysToolsCfg.getLibrariesFolder();
        this.log("getLibrariesFromFolder() : folder = '" + dir + "'");
        IResource resource = EclipseProjUtil.getResource(project, dir);
        if (resource == null) {
            MsgBox.error("Folder '" + dir + "' not found !");
            return voidLib;
        }
        if (!(resource instanceof IFolder)) {
            MsgBox.error("'" + dir + "' is not a folder !");
            return voidLib;
        }
        if (!resource.isAccessible()) {
            MsgBox.error("Folder '" + dir + "' is not accessible !");
            return voidLib;
        }
        IFolder folder = (IFolder)resource;
        IResource[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException ce) {
            MsgBox.error("Cannot get files from folder '" + dir + "' (CoreException)", ce);
            return voidLib;
        }
        LinkedList<String> libraries = new LinkedList<String>();
        IResource[] iResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            String ext;
            IResource r = iResourceArray[n2];
            if (r instanceof IFile && ("jar".equals(ext = r.getFileExtension()) || "zip".equals(ext))) {
                String fileInProject = r.getProjectRelativePath().toString();
                String libFile = EclipseProjUtil.getAbsolutePathInFileSystem(project, fileInProject);
                libraries.add(libFile);
            }
            ++n2;
        }
        this.log("getLibrariesFromFolder() : libraries size = " + libraries.size());
        return libraries.toArray(new String[0]);
    }

    private String getRepositoryFileName(String sDatabaseName) {
        TelosysToolsCfg telosysToolsCfg = ProjectConfigManager.loadProjectConfig(this._editor.getProject());
        String dir = telosysToolsCfg.getModelsFolder();
        return FileUtil.buildFilePath((String)dir, (String)(String.valueOf(sDatabaseName) + ".dbrep"));
    }

    private void showLibraries() {
        this.log("--- Show libraries");
        StringBuffer sb = new StringBuffer();
        sb.append("Libraries : \n\n");
        String[] libraries = this.getLibraries();
        if (libraries != null && libraries.length > 0) {
            String[] stringArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(String.valueOf(s) + "\n");
                ++n2;
            }
        } else {
            sb.append("No library !\n");
        }
        this.log("--- Show libraries : " + libraries.length);
        MsgBox.info(sb.toString());
    }

    private void actionTestConnection() {
        Shell shell = Util.cursorWait();
        DatabaseConfiguration databaseConfiguration = this.getCurrentDatabaseConfig(true);
        TelosysProject telosysProject = this.getTelosysProject();
        try {
            DbConnectionStatus status = telosysProject.checkDatabaseConnectionWithStatus(databaseConfiguration);
            MsgBox.info("Connection OK.\n\n . product : '" + status.getProductName() + "' \n" + " . version : '" + status.getProductVersion() + "' \n" + " . catalog : '" + status.getCatalog() + "' \n" + " . schema  : '" + status.getSchema() + "' \n");
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot connect", e);
        }
        Util.cursorArrow(shell);
    }

    private void actionGetInformations() {
        Shell shell = Util.cursorWait();
        DatabaseConfiguration databaseConfiguration = this.getCurrentDatabaseConfig(true);
        TelosysProject telosysProject = this.getTelosysProject();
        try {
            DbInfo dbInfo = telosysProject.getDatabaseInfo(databaseConfiguration);
            this._InfoURL.setText(dbInfo.getUrl());
            this._InfoProdName.setText(dbInfo.getDatabaseProductName());
            this._InfoProdVer.setText(dbInfo.getDatabaseProductVersion());
            this._InfoDriverName.setText(dbInfo.getDriverName());
            this._InfoDriverVer.setText(dbInfo.getDriverVersion());
            this._InfoMaxConn.setText("" + dbInfo.getMaxConnections());
            this._InfoUser.setText(dbInfo.getUserName());
            this._InfoIsolation.setText("" + dbInfo.getDefaultTransactionIsolation());
            this._InfoCatalogTerm.setText(dbInfo.getCatalogTerm());
            this._InfoCatalogSepar.setText(dbInfo.getCatalogSeparator());
            this._InfoSchemaTerm.setText(dbInfo.getSchemaTerm());
            this._InfoSearchEscape.setText(dbInfo.getSearchStringEscape());
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot get database info", e);
        }
        Util.cursorArrow(shell);
    }

    private void actionGetMetaData(int whatElse) {
        Shell shell = Util.cursorWait();
        DatabaseConfiguration databaseConfiguration = this.getCurrentDatabaseConfig(true);
        TelosysProject telosysProject = this.getTelosysProject();
        MetaDataOptionsImpl options = new MetaDataOptionsImpl();
        switch (whatElse) {
            case 1: {
                this.log("get columns ... ");
                options.setColumns(true);
                break;
            }
            case 2: {
                this.log("get primary keys ... ");
                options.setPrimaryKeys(true);
                break;
            }
            case 3: {
                this.log("get foreign keys ... ");
                options.setForeignKeys(true);
                break;
            }
            case 11: {
                this.log("get catalogs ... ");
                options.setCatalogs(true);
                break;
            }
            case 12: {
                this.log("get schemas ... ");
                options.setSchemas(true);
                break;
            }
            default: {
                this.log("default : get tables ... ");
                options.setTables(true);
            }
        }
        DbMetadataConsole.reset();
        try {
            String result = telosysProject.getMetaData(databaseConfiguration, (MetaDataOptions)options);
            this._tMetaData.setText(result);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot get metadata", e);
        }
        Util.cursorArrow(shell);
    }

    private IProject getEclipseProject() {
        IProject project = this._editor.getProject();
        if (project == null) {
            MsgBox.error("actionGenerateRepository() : Cannot get project ");
        }
        return project;
    }

    private void syncRepoFolder() {
        IProject project = this.getEclipseProject();
        TelosysToolsCfg telosysToolsCfg = ProjectConfigManager.loadProjectConfig(project);
        this.log("repositoriesFolder = " + telosysToolsCfg.getModelsFolder());
        IFolder modelsFolder = project.getFolder(telosysToolsCfg.getModelsFolder());
        this.log("is repositories Folder Synchronized = " + modelsFolder.isSynchronized(2));
        try {
            modelsFolder.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            this.log("refreshLocal : CoreException ");
        }
        this.log("is repositories Folder Synchronized = " + modelsFolder.isSynchronized(2));
    }

    private void actionNewDatabase() {
        Display display = Display.getCurrent();
        DialogBoxNewDatabase dialogBox = new DialogBoxNewDatabase(display.getActiveShell(), this._editor.getDatabasesConfigurations());
        this.log("openDialogBox() : before dialog.open() ----- ");
        int iRet = dialogBox.open();
        this.log("openDialogBox() : after dialog.open() ----- ");
        if (iRet == 0) {
            int databaseIdSelected = dialogBox.getDatabaseId();
            DatabaseType databaseTypeSelected = dialogBox.getDatabaseType();
            if (databaseIdSelected < 0) {
                MsgBox.error("Invalid database id " + databaseIdSelected);
                return;
            }
            if (databaseTypeSelected == null) {
                MsgBox.error("No database type selected ! ");
                return;
            }
            DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration(databaseIdSelected, databaseTypeSelected);
            DatabasesConfigurations databasesConfigurations = this._editor.getDatabasesConfigurations();
            databasesConfigurations.storeDatabaseConfiguration(databaseConfiguration);
            this.setDirty();
            this.clearFields();
            this.populateComboDatabases();
            this.selectDatabaseInCombo(databaseIdSelected);
        }
    }

    private void selectFirstDatabaseInCombo() {
        if (this._ComboDatabases.getItemCount() > 0) {
            this._ComboDatabases.select(0);
            this.populateDatabaseConfigFields(this._ComboDatabases);
        }
    }

    private void selectDatabaseInCombo(int databaseId) {
        String sDbId = String.valueOf(databaseId) + " ";
        int n = this._ComboDatabases.getItemCount();
        int i = 0;
        while (i < n) {
            String s = this._ComboDatabases.getItem(i);
            if (s.startsWith(sDbId)) {
                this._ComboDatabases.select(i);
                this.populateDatabaseConfigFields(this._ComboDatabases);
                return;
            }
            ++i;
        }
    }

    private void actionDeleteDatabase() {
        DatabaseConfiguration db = this.getCurrentDatabaseConfig(false);
        if (db != null) {
            String sMsg = "Do you realy want to delete this database configuration ?\n\n. Id : " + db.getDatabaseId() + "\n" + ". Name : " + db.getDatabaseName();
            if (MsgBox.confirm(" Confirm generation", sMsg)) {
                DatabasesConfigurations databasesConfigurations = this._editor.getDatabasesConfigurations();
                databasesConfigurations.removeDatabaseConfiguration(db.getDatabaseId());
                this.setDirty();
                this.clearFields();
                this.populateComboDatabases();
                this.selectFirstDatabaseInCombo();
            }
        } else {
            MsgBox.info("No current database.");
        }
    }

    private void actionCreateNewDbModel() {
        boolean repositoryCreated = false;
        String sRepositoryFile = null;
        IProject project = this._editor.getProject();
        if (project == null) {
            MsgBox.error("actionCreateNewDbModel() : Cannot get project ");
            return;
        }
        DatabaseConfiguration db = this.getCurrentDatabaseConfig(true);
        if (db == null) {
            return;
        }
        String sDatabaseName = db.getDatabaseName();
        sRepositoryFile = this.getRepositoryFileName(db.getDatabaseName());
        String sMsg = "This operation will replace the current version of the database model if it exists.\n\nDatabase model file : \n" + sRepositoryFile + "\n\n" + "From database name : \n" + sDatabaseName + "\n\n" + "Launch the generation ?";
        if (MsgBox.confirm(" Confirm generation", sMsg)) {
            Shell shell = Util.cursorWait();
            try {
                repositoryCreated = this.createNewDbModel(db);
            }
            catch (Exception e) {
                MsgBox.error("Cannot create database model", e);
            }
            if (repositoryCreated) {
                this.syncRepoFolder();
                Util.cursorArrow(shell);
                MsgBox.info("Database model created.\n\nSee file " + sRepositoryFile);
            } else {
                Util.cursorArrow(shell);
            }
        }
    }

    private boolean createNewDbModel(DatabaseConfiguration db) {
        DbModelConsole.reset();
        try {
            TelosysProject telosysProject = this.getTelosysProject();
            telosysProject.createNewDbModel(db);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot create database model", e);
            return false;
        }
        return true;
    }

    private int updateDbModel(DatabaseConfiguration db) throws TelosysToolsException {
        DbModelConsole.reset();
        TelosysProject telosysProject = this.getTelosysProject();
        ChangeLog changeLog = telosysProject.updateDbModel(db);
        return changeLog.getNumberOfEntities();
    }

    private void actionUpdateDbModel() {
        String sMsg;
        int nbChanges = 0;
        boolean repositoryUpdated = false;
        IProject project = this._editor.getProject();
        if (project == null) {
            MsgBox.error("actionGenerateRepository() : Cannot get project ");
            return;
        }
        DatabaseConfiguration db = this.getCurrentDatabaseConfig(true);
        if (db == null) {
            return;
        }
        String sDatabaseName = db.getDatabaseName();
        String sRepositoryFile = this.getRepositoryFileName(db.getDatabaseName());
        IFile iFile = project.getFile(sRepositoryFile);
        if (!iFile.exists()) {
            MsgBox.info("The database model file doesn't exist => cannot update.\n\n Database model file : \n" + sRepositoryFile);
            return;
        }
        if (db != null && MsgBox.confirm(" Confirm ", sMsg = "This operation will update the current database model if it exists.\n\nDatabase model file : \n" + sRepositoryFile + "\n\n" + "From database name : \n" + sDatabaseName + "\n\n" + "Launch update ?")) {
            Shell shell = Util.cursorWait();
            try {
                nbChanges = this.updateDbModel(db);
                repositoryUpdated = true;
            }
            catch (Throwable e) {
                MsgBox.error("Exception : " + e.getClass() + " \n\n" + e.getMessage());
            }
            if (repositoryUpdated) {
                this.syncRepoFolder();
                Util.cursorArrow(shell);
                String msgChanges = "No change.";
                if (nbChanges > 0) {
                    msgChanges = String.valueOf(nbChanges) + " change(s).\n\n" + "See the update log file for details.";
                }
                MsgBox.info("Database model updated.\n\nDatabase model file : \n" + sRepositoryFile + "\n" + "\n" + msgChanges);
            } else {
                Util.cursorArrow(shell);
            }
        }
    }
}

