/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.util.Collection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class CompositesList {
    private ScrolledComposite scrolledComposite = null;
    private Composite composite = null;
    private int size = 0;

    public CompositesList(Composite parent, Object layoutData) {
        this.scrolledComposite = new ScrolledComposite(parent, 2816);
        if (layoutData != null) {
            this.scrolledComposite.setLayoutData(layoutData);
        }
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.composite.setLayout((Layout)rowLayout);
        this.scrolledComposite.setContent((Control)this.composite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    protected abstract Composite addRow(Composite var1, Object var2);

    protected abstract void deleteItemInModel(Object var1);

    public int getSize() {
        return this.size;
    }

    public void refresh() {
        this.composite.pack();
        this.scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
        this.scrolledComposite.redraw();
    }

    private void clearAll(boolean refresh) {
        Control[] controls = this.composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c != null && c instanceof Composite) {
                this.deleteRow((Composite)c);
            }
            ++i;
        }
        if (refresh) {
            this.refresh();
        }
        this.size = 0;
    }

    public Composite[] getAllRows() {
        Control[] controls = this.composite.getChildren();
        Composite[] rows = new Composite[controls.length];
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c instanceof Composite) {
                rows[i] = (Composite)c;
            }
            ++i;
        }
        return rows;
    }

    public void clearAll() {
        this.clearAll(true);
    }

    protected void deleteRow(Composite row) {
        Control[] controls = row.getChildren();
        int i = 0;
        while (i < controls.length) {
            Control c = controls[i];
            if (c != null) {
                c.dispose();
            }
            ++i;
        }
        row.dispose();
        --this.size;
    }

    private int populate(Collection<? extends Object> items, boolean refresh) {
        this.size = 0;
        for (Object object : items) {
            this.addRow(this.composite, object);
            ++this.size;
        }
        if (refresh) {
            this.refresh();
        }
        return this.size;
    }

    public int populate(Collection<? extends Object> items) {
        return this.populate(items, true);
    }

    public int repopulate(Collection<? extends Object> items) {
        this.clearAll(false);
        return this.populate(items, true);
    }
}

