/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.commons.DateUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.dbrep.DialogBox;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForDate;

public class DialogBoxForDate
extends DialogBox {
    private boolean bJavaUtilDate = false;
    private boolean bJavaSqlDate = false;
    private boolean bJavaSqlTime = false;
    private boolean bJavaSqlTimestamp = false;
    private Button _rbDateOnly = null;
    private Button _rbTimeOnly = null;
    private Button _rbDateAndTime = null;
    private Button _cbNotNull = null;
    private Button _cbPast = null;
    private Button _cbFuture = null;
    private Button _cbBefore = null;
    private Text _textBefore = null;
    private Button _cbAfter = null;
    private Text _textAfter = null;
    private Label _labelInputFormat = null;
    private SpecialValueForDate _value = null;

    public DialogBoxForDate(Shell parentShell, SpecialValueForDate value) {
        super(parentShell, value);
        this._value = value;
        String sJavaType = this._value.getJavaType();
        this.log("CONSTRUCTOR : java type = " + sJavaType);
        if ("java.sql.Time".equals(sJavaType)) {
            this.bJavaSqlTime = true;
        }
        if ("java.sql.Timestamp".equals(sJavaType)) {
            this.bJavaSqlTimestamp = true;
        }
        if ("java.sql.Date".equals(sJavaType)) {
            this.bJavaSqlDate = true;
        }
        if ("java.util.Date".equals(sJavaType)) {
            this.bJavaUtilDate = true;
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        this.log("createContents() ...");
        Control result = super.createContents(parent);
        this.setMessage("Date type and validation rules", 1);
        this.setHelpAvailable(false);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.log("createDialogArea() ...");
        Composite content = this.createDialogAreaContainer(parent);
        this.createDateTypeGroup(content);
        this.createValidationGroup(content);
        this.dataToView();
        return content;
    }

    private Group createDateTypeGroup(Composite container) {
        this.log("createDatabaseValuesGroup() ...");
        Group group = this.createDialogAreaGroup(container, " Date type ");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                if (button.getSelection()) {
                    DialogBoxForDate.this.refreshHelpInputFormat();
                }
                if (button == DialogBoxForDate.this._rbTimeOnly) {
                    DialogBoxForDate.this.manageEnableDisable(DialogBoxForDate.this._rbTimeOnly.getSelection());
                }
            }
        };
        this._rbDateAndTime = new Button((Composite)group, 16);
        this._rbDateAndTime.setText("Date and Time");
        this._rbDateAndTime.addSelectionListener((SelectionListener)listener);
        this._rbDateOnly = new Button((Composite)group, 16);
        this._rbDateOnly.setText("Date only");
        this._rbDateOnly.addSelectionListener((SelectionListener)listener);
        this._rbTimeOnly = new Button((Composite)group, 16);
        this._rbTimeOnly.setText("Time only");
        this._rbTimeOnly.addSelectionListener((SelectionListener)listener);
        return group;
    }

    private Group createValidationGroup(Composite container) {
        Group group = this.createDialogAreaGroup(container, " Validation rules ");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        this._cbNotNull = new Button((Composite)group, 32);
        this._cbNotNull.setText("Not null ");
        this._cbNotNull.setSelection(false);
        GridData gdSpan = new GridData();
        gdSpan.verticalAlignment = 4;
        gdSpan.grabExcessVerticalSpace = true;
        gdSpan.horizontalSpan = 2;
        gdSpan.widthHint = 400;
        gdSpan.minimumWidth = 400;
        GridData gdText = new GridData();
        gdText.widthHint = 200;
        gdText.minimumWidth = 200;
        this._cbPast = new Button((Composite)group, 32);
        this._cbPast.setText("In the Past");
        this._cbPast.setSelection(false);
        this._cbPast.setLayoutData((Object)gdSpan);
        this._cbPast.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogBoxForDate.this._cbPast.getSelection()) {
                    DialogBoxForDate.this._cbFuture.setSelection(false);
                }
            }
        });
        this._cbFuture = new Button((Composite)group, 32);
        this._cbFuture.setText("In the Future");
        this._cbFuture.setSelection(false);
        this._cbFuture.setLayoutData((Object)gdSpan);
        this._cbFuture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DialogBoxForDate.this._cbFuture.getSelection()) {
                    DialogBoxForDate.this._cbPast.setSelection(false);
                }
            }
        });
        this._cbAfter = new Button((Composite)group, 32);
        this._cbAfter.setText("After");
        this._cbAfter.setSelection(false);
        this._textAfter = new Text((Composite)group, 2048);
        this._textAfter.setText("");
        this._textAfter.setLayoutData((Object)gdText);
        this._cbBefore = new Button((Composite)group, 32);
        this._cbBefore.setText("Before");
        this._cbBefore.setSelection(false);
        this._textBefore = new Text((Composite)group, 2048);
        this._textBefore.setText("");
        this._textBefore.setLayoutData((Object)gdText);
        this._labelInputFormat = new Label((Composite)group, 0);
        this._labelInputFormat.setText("Use ISO format");
        this._labelInputFormat.setLayoutData((Object)gdSpan);
        return group;
    }

    private void refreshHelpInputFormat() {
        if (this._rbDateOnly.getSelection()) {
            this._labelInputFormat.setText("Enter DATE in ISO format ( 'YYYY-MM-DD' )");
        } else if (this._rbTimeOnly.getSelection()) {
            this._labelInputFormat.setText("Enter TIME in ISO format ( 'HH:MM:SS' )");
        } else if (this._rbDateAndTime.getSelection()) {
            this._labelInputFormat.setText("Enter DATE with TIME in ISO format ( 'YYYY-MM-DD HH:MM:SS' )");
        }
    }

    @Override
    public boolean onOK() {
        this.log("onOK");
        if (this.checkViewValues()) {
            this.viewToData();
            return true;
        }
        return false;
    }

    private void dataToView() {
        this.log("dataToView : past   : " + this._value.isDateValidationPast());
        this.log("dataToView : future : " + this._value.isDateValidationFuture());
        this._cbNotNull.setSelection(this._value.isDateValidationNotNull());
        this._cbPast.setSelection(this._value.isDateValidationPast());
        this._cbFuture.setSelection(this._value.isDateValidationFuture());
        if (this._value.isDateValidationBefore()) {
            this._cbBefore.setSelection(true);
            this._textBefore.setText(this._value.getDateValidationBefore());
        }
        if (this._value.isDateValidationAfter()) {
            this._cbAfter.setSelection(true);
            this._textAfter.setText(this._value.getDateValidationAfter());
        }
        if (this.bJavaUtilDate) {
            this.log("java.util.date");
            this._rbDateAndTime.setSelection(this._value.isDateAndTime());
            this._rbDateOnly.setSelection(this._value.isDateOnly());
            this._rbTimeOnly.setSelection(this._value.isTimeOnly());
        } else {
            this.log("Not java.util.date");
            this._rbDateOnly.setEnabled(false);
            this._rbTimeOnly.setEnabled(false);
            this._rbDateAndTime.setEnabled(false);
            if (this.bJavaSqlDate) {
                this._rbDateOnly.setSelection(true);
            } else if (this.bJavaSqlTime) {
                this._rbTimeOnly.setSelection(true);
            } else if (this.bJavaSqlTimestamp) {
                this._rbDateAndTime.setSelection(true);
            }
        }
        this.refreshHelpInputFormat();
        this.manageEnableDisable(this._rbTimeOnly.getSelection());
    }

    private void manageEnableDisable(boolean bTimeOnly) {
        if (bTimeOnly) {
            this._cbPast.setEnabled(false);
            this._cbPast.setSelection(false);
            this._cbFuture.setEnabled(false);
            this._cbFuture.setSelection(false);
        } else {
            this._cbPast.setEnabled(true);
            this._cbFuture.setEnabled(true);
        }
    }

    private boolean checkViewValues() {
        String s;
        String m1 = "Invalid 'before' limit";
        String m2 = "Invalid 'after' limit";
        if (this._cbBefore.getSelection()) {
            s = this._textBefore.getText();
            if (s == null) {
                MsgBox.error(m1);
                return false;
            }
            if (s.length() == 0) {
                MsgBox.error(m1);
                return false;
            }
            if (!this.checkDate(s)) {
                MsgBox.error(m1);
                return false;
            }
        }
        if (this._cbAfter.getSelection()) {
            s = this._textAfter.getText();
            if (s == null) {
                MsgBox.error(m2);
                return false;
            }
            if (s.length() == 0) {
                MsgBox.error(m2);
                return false;
            }
            if (!this.checkDate(s)) {
                MsgBox.error(m2);
                return false;
            }
        }
        return true;
    }

    private boolean checkDate(String s) {
        block6: {
            block5: {
                try {
                    if (!this._rbDateOnly.getSelection()) break block5;
                    DateUtil.parseDate((String)s);
                    return true;
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            if (!this._rbTimeOnly.getSelection()) break block6;
            DateUtil.parseTime((String)s);
            return true;
        }
        if (this._rbDateAndTime.getSelection()) {
            DateUtil.parseDateTime((String)s);
            return true;
        }
        MsgBox.error("Unknown date type : Date only, Time only, Date and Time ?");
        return false;
    }

    private void viewToData() {
        if (this._rbDateAndTime.getSelection()) {
            this._value.setDateAndTime();
        }
        if (this._rbDateOnly.getSelection()) {
            this._value.setDateOnly();
        }
        if (this._rbTimeOnly.getSelection()) {
            this._value.setTimeOnly();
        }
        this._value.setDateValidationNotNull(this._cbNotNull.getSelection());
        this._value.setDateValidationPast(this._cbPast.getSelection());
        this._value.setDateValidationFuture(this._cbFuture.getSelection());
        if (this._cbBefore.getSelection()) {
            this._value.setDateValidationBefore(true, this._textBefore.getText());
        } else {
            this._value.setDateValidationBefore(false, null);
        }
        if (this._cbAfter.getSelection()) {
            this._value.setDateValidationAfter(true, this._textAfter.getText());
        } else {
            this._value.setDateValidationAfter(false, null);
        }
    }

    @Override
    public Object getValue() {
        this.log("getValue() ... return " + this._value);
        return this._value;
    }
}

