/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.commons.JavaValue;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.editors.dbrep.DialogBox;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValueForNumber;

public class DialogBoxForNumber
extends DialogBox {
    private Button _cbNotNull = null;
    private Text _textMinValue = null;
    private Text _textMaxValue = null;
    private Text _textDefaultValue = null;
    private SpecialValueForNumber _value = null;

    public DialogBoxForNumber(Shell parentShell, SpecialValueForNumber value) {
        super(parentShell, value);
        this._value = value;
    }

    @Override
    protected Control createContents(Composite parent) {
        this.log("createContents() ...");
        Control result = super.createContents(parent);
        this.setMessage("Number validation rules", 1);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        this.log("createDialogArea() ...");
        Composite content = this.createDialogAreaContainer(parent);
        this.createDefaultValueGroup(content);
        this.createValidationGroup(content);
        this.dataToView();
        return content;
    }

    private Group createDefaultValueGroup(Composite container) {
        this.log("createDefaultValueGroup() ...");
        Group group = this.createDialogAreaGroup(container, null);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gdSpan = new GridData();
        gdSpan.verticalAlignment = 4;
        gdSpan.grabExcessVerticalSpace = true;
        gdSpan.horizontalSpan = 2;
        GridData gdLabel = new GridData();
        GridData gdText = new GridData();
        gdText.widthHint = 200;
        gdText.minimumWidth = 200;
        Label label = new Label((Composite)group, 0);
        label.setText("Default value : ");
        label.setLayoutData((Object)gdLabel);
        this._textDefaultValue = new Text((Composite)group, 2048);
        this._textDefaultValue.setText("");
        this._textDefaultValue.setLayoutData((Object)gdText);
        return group;
    }

    private Group createValidationGroup(Composite container) {
        this.log("createValidationGroup() ...");
        Group group = this.createDialogAreaGroup(container, " Validation rules ");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)gridLayout);
        GridData gdSpan = new GridData();
        gdSpan.verticalAlignment = 4;
        gdSpan.grabExcessVerticalSpace = true;
        gdSpan.horizontalSpan = 2;
        GridData gdLabel = new GridData();
        GridData gdText = new GridData();
        gdText.widthHint = 200;
        gdText.minimumWidth = 200;
        this._cbNotNull = new Button((Composite)group, 32);
        this._cbNotNull.setText("Not null ");
        this._cbNotNull.setSelection(false);
        this._cbNotNull.setLayoutData((Object)gdSpan);
        Label label = new Label((Composite)group, 0);
        label.setText("Minimum : ");
        label.setLayoutData((Object)gdLabel);
        this._textMinValue = new Text((Composite)group, 2048);
        this._textMinValue.setText("");
        this._textMinValue.setLayoutData((Object)gdText);
        label = new Label((Composite)group, 0);
        label.setText("Maximum : ");
        label.setLayoutData((Object)gdLabel);
        this._textMaxValue = new Text((Composite)group, 2048);
        this._textMaxValue.setText("");
        this._textMaxValue.setLayoutData((Object)gdText);
        return group;
    }

    @Override
    public boolean onOK() {
        this.log("onOK");
        if (this.checkViewValues()) {
            this.viewToData();
            return true;
        }
        return false;
    }

    private void dataToView() {
        this.log("dataToView() ...");
        this._cbNotNull.setSelection(this._value.isNotNull());
        this._textDefaultValue.setText(this._value.getDefaultValue());
        this._textMinValue.setText(this._value.getMinValue());
        this._textMaxValue.setText(this._value.getMaxValue());
        if (this._value.isPrimitiveType()) {
            this._cbNotNull.setSelection(false);
            this._cbNotNull.setEnabled(false);
        } else {
            this._cbNotNull.setEnabled(true);
        }
        this.log("dataToView() : END");
    }

    private boolean checkViewValues() {
        if (!this.checkDefaultValue(this._textDefaultValue.getText(), "Invalid default value")) {
            return false;
        }
        if (!this.checkNumericValue(this._textMinValue.getText(), "Invalid minimum value")) {
            return false;
        }
        if (!this.checkNumericValue(this._textMaxValue.getText(), "Invalid maximum value")) {
            return false;
        }
        return this.isLowerThan(this._textMinValue.getText(), this._textMaxValue.getText(), "Min/Max inverted");
    }

    private void viewToData() {
        this.log("viewToData() ...");
        this._value.setNotNull(this._cbNotNull.getSelection());
        this._value.setDefaultValue(this.trim(this._textDefaultValue.getText()));
        this._value.setMinValue(this.trim(this._textMinValue.getText()));
        this._value.setMaxValue(this.trim(this._textMaxValue.getText()));
    }

    private boolean checkDefaultValue(String s, String msg) {
        if (StrUtil.nullOrVoid((String)s)) {
            return true;
        }
        String type = this._value.getJavaType();
        String value = s.trim();
        if (JavaValue.isValidForNumberType((String)value, (String)type)) {
            return true;
        }
        MsgBox.error(msg);
        return false;
    }
}

