/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.editors.dbrep.CompositesList;
import org.telosys.tools.eclipse.plugin.editors.dbrep.DialogBoxForLink;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditorPageModelLinks;
import org.telosys.tools.generic.model.Cardinality;
import org.telosys.tools.repository.model.EntityInDbModel;
import org.telosys.tools.repository.model.ForeignKeyInDbModel;
import org.telosys.tools.repository.model.LinkInDbModel;
import org.telosys.tools.repository.model.RelationLinksInDbModel;
import org.telosys.tools.repository.model.RepositoryModel;

public class LinksList
extends CompositesList {
    private final RepositoryModel repositoryModel;
    private final RepositoryEditorPageModelLinks _editorPage;

    public LinksList(Composite parent, Object layoutData, RepositoryEditorPageModelLinks editorPage) {
        super(parent, layoutData);
        if (editorPage.getRepositoryModel() == null) {
            MsgBox.error("Repository model is not yet set in the editor page");
        }
        this.repositoryModel = editorPage.getRepositoryModel();
        this._editorPage = editorPage;
    }

    protected void log(String s) {
        PluginLogger.log(this, s);
    }

    @Override
    protected Composite addRow(Composite parent, Object item) {
        int height = 22;
        int width0 = 22;
        int width1 = 220;
        int width2 = 100;
        int width3 = 220;
        int width4 = 100;
        int width_icon = 20;
        Display device = Display.getCurrent();
        Color white = device.getSystemColor(1);
        Color red = device.getSystemColor(3);
        Color blue = device.getSystemColor(9);
        Color gray = new Color((Device)device, 240, 240, 240);
        GridLayout gridLayout = new GridLayout(7, false);
        Composite row = new Composite(parent, 0);
        row.setLayout((Layout)gridLayout);
        row.setBackground(white);
        if (!(item instanceof LinkInDbModel)) {
            MsgBox.error("Links list - addRow() : item is not an instance of Link");
            return row;
        }
        LinkInDbModel link = (LinkInDbModel)item;
        row.setData((Object)link);
        String side = "owning side ";
        if (!link.isOwningSide()) {
            side = "inverse side of \"" + link.getInverseSideLinkId() + "\" ";
        }
        String toolTip = " Link id : \"" + link.getId() + "\" " + "\n " + side + "\n mapped by : " + link.getMappedBy() + "\n target entity : " + link.getTargetEntityClassName() + "\n fetch : " + link.getFetchType() + "\n cascade : " + link.getCascadeOptions() + "\n optional : " + link.getOptional();
        GridData gd = new GridData(width0, height);
        gd.verticalSpan = 2;
        Button b = new Button(row, 0x1000020);
        b.setData((Object)row);
        b.setLayoutData((Object)gd);
        b.setSelection(link.isSelected());
        b.setBackground(white);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof Button) {
                    Button b = (Button)event.widget;
                    LinksList.this.buttonChangeUseFlag(b);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label label1 = new Label(row, 0x1000000);
        label1.setText(link.getSourceTableName());
        label1.setLayoutData((Object)new GridData(width1, height));
        label1.setBackground(gray);
        if (link.isOwningSide()) {
            label1.setToolTipText("Owning side");
        } else {
            label1.setToolTipText("Inverse side");
        }
        Label label = new Label(row, 16384);
        label.setLayoutData((Object)new GridData(width_icon, height));
        label.setBackground(white);
        label.setToolTipText(toolTip);
        this.setForeignKeyOrJoinTable(link, label, true);
        Label label2 = new Label(row, 0x1000000);
        String s = "";
        if (link.getCardinality() == Cardinality.ONE_TO_MANY) {
            s = "1  ----->  *";
        }
        if (link.getCardinality() == Cardinality.MANY_TO_ONE) {
            s = "*  ----->  1";
        }
        if (link.getCardinality() == Cardinality.MANY_TO_MANY) {
            s = "*  ----->  *";
        }
        if (link.getCardinality() == Cardinality.ONE_TO_ONE) {
            s = "1  ----->  1";
        }
        label2.setText(s);
        label2.setLayoutData((Object)new GridData(width2, height));
        label2.setBackground(white);
        label2.setToolTipText(toolTip);
        if (link.isOwningSide()) {
            label2.setForeground(red);
        } else {
            label2.setForeground(blue);
        }
        label = new Label(row, 16384);
        label.setLayoutData((Object)new GridData(width_icon, height));
        label.setBackground(white);
        this.setForeignKeyOrJoinTable(link, label, false);
        label = new Label(row, 0x1000000);
        label.setText(link.getTargetTableName());
        label.setLayoutData((Object)new GridData(width3, height));
        label.setBackground(gray);
        if (link.isOwningSide()) {
            label.setToolTipText("");
        } else {
            label.setToolTipText("Owning side");
        }
        Button b2 = new Button(row, 0);
        b2.setText("Edit ... ");
        b2.setData((Object)row);
        b2.setLayoutData((Object)new GridData(width4, height));
        b2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof Button) {
                    Button b = (Button)event.widget;
                    LinksList.this.buttonEditLink(b);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label l = new Label(row, 16384);
        l.setText(String.valueOf(link.getFieldType()) + "  " + link.getFieldName());
        l.setLayoutData((Object)new GridData(width1, height));
        l.setBackground(white);
        l.setToolTipText(toolTip);
        label = new Label(row, 16384);
        label.setLayoutData((Object)new GridData(width_icon, height));
        label.setBackground(white);
        if (link.isOwningSide()) {
            label.setImage(PluginImages.getImage("ARROW_RIGHT"));
        } else {
            label.setText("");
        }
        l = new Label(row, 0x1000000);
        l.setText(link.getCardinality().getText());
        l.setLayoutData((Object)new GridData(width2, height));
        l.setBackground(white);
        l.setToolTipText(toolTip);
        label = new Label(row, 16384);
        label.setBackground(white);
        label.setLayoutData((Object)new GridData(width_icon, height));
        if (!link.isOwningSide()) {
            label.setImage(PluginImages.getImage("ARROW_LEFT"));
        } else {
            label.setText("");
        }
        label = new Label(row, 16384);
        label.setBackground(white);
        label.setText("");
        if (!link.isOwningSide()) {
            label.setText(link.getMappedBy());
            label.setToolTipText("mapped by " + link.getMappedBy());
        } else {
            label.setToolTipText("");
        }
        b2 = new Button(row, 0);
        b2.setText("Remove ");
        b2.setLayoutData((Object)new GridData(width4, height));
        b2.setData((Object)row);
        b2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof Button) {
                    Button b = (Button)event.widget;
                    LinksList.this.buttonRemoveLink(b);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return row;
    }

    private void setForeignKeyOrJoinTable(LinkInDbModel link, Label label, boolean bOwningSide) {
        if (bOwningSide == link.isOwningSide()) {
            if (link.isBasedOnForeignKey()) {
                String fkName = link.getForeignKeyName();
                ForeignKeyInDbModel fk = this.repositoryModel.getForeignKeyByName(fkName);
                if (fk != null) {
                    label.setImage(PluginImages.getImage("FOREIGNKEY"));
                    label.setToolTipText(" Foreign Key : \"" + fkName + "\" ");
                } else {
                    label.setText("FK");
                    label.setToolTipText(" (!) Non existent Foreign Key : \"" + fkName + "\" ");
                }
            } else if (link.isBasedOnJoinTable()) {
                String joinTableName = link.getJoinTableName();
                EntityInDbModel entity = this.repositoryModel.getEntityByTableName(joinTableName);
                if (entity != null) {
                    label.setImage(PluginImages.getImage("JOINTABLE"));
                    label.setToolTipText(" Join Table : \"" + joinTableName + "\"");
                } else {
                    label.setText("JT");
                    label.setToolTipText(" (!) Non existent Join Table : \"" + joinTableName + "\" ");
                }
            }
        }
    }

    private Composite getRowFromWidget(Button button) {
        Object buttonData = button.getData();
        if (buttonData == null) {
            MsgBox.error("Button data is null !");
            return null;
        }
        if (!(buttonData instanceof Composite)) {
            MsgBox.error("Button data is not an instance of Composite !");
            return null;
        }
        return (Composite)buttonData;
    }

    private LinkInDbModel getLinkFromButton(Button button) {
        Composite row = this.getRowFromWidget(button);
        LinkInDbModel link = this.getLinkFromRow(row);
        if (link == null) {
            MsgBox.error("Row data is null (no link for this row) !");
            return null;
        }
        return link;
    }

    private void buttonChangeUseFlag(Button button) {
        LinkInDbModel link = this.getLinkFromButton(button);
        if (link == null) {
            return;
        }
        if (button.getSelection() != link.isSelected()) {
            link.setSelected(button.getSelection());
            this._editorPage.setDirty();
        }
    }

    private void buttonEditLink(Button b) {
        this.log("EDIT link ...");
        LinkInDbModel link = this.getLinkFromButton(b);
        if (link == null) {
            return;
        }
        String linkBefore = link.getComparableString();
        this.log("EDIT link : link before = " + linkBefore);
        DialogBoxForLink dialog = new DialogBoxForLink(b.getDisplay().getActiveShell(), link);
        int iRet = dialog.open();
        if (iRet == 0) {
            String linkAfter = link.getComparableString();
            this.log("EDIT link : link after = " + linkAfter);
            if (!linkBefore.equals(linkAfter)) {
                RelationLinksInDbModel relation;
                LinkInDbModel inverseSideLink;
                this.log("EDIT link : change detected => reprint the list...");
                if (link.isOwningSide() && (inverseSideLink = (relation = this.repositoryModel.getRelationByLinkId(link.getId())).getInverseSideLink()) != null) {
                    Cardinality sOwningSideCardinality = link.getCardinality();
                    Cardinality sOldInverseSideCardinality = inverseSideLink.getCardinality();
                    Cardinality sNewInverseSideCardinality = Cardinality.UNDEFINED;
                    if (sOwningSideCardinality == Cardinality.ONE_TO_ONE) {
                        sNewInverseSideCardinality = Cardinality.ONE_TO_ONE;
                    } else if (sOwningSideCardinality == Cardinality.ONE_TO_MANY) {
                        sNewInverseSideCardinality = Cardinality.MANY_TO_ONE;
                    } else if (sOwningSideCardinality == Cardinality.MANY_TO_ONE) {
                        sNewInverseSideCardinality = Cardinality.ONE_TO_MANY;
                    } else if (sOwningSideCardinality == Cardinality.MANY_TO_MANY) {
                        sNewInverseSideCardinality = Cardinality.MANY_TO_MANY;
                    }
                    if (sNewInverseSideCardinality != null && sNewInverseSideCardinality != inverseSideLink.getCardinality()) {
                        inverseSideLink.setCardinality(sNewInverseSideCardinality);
                        if (sNewInverseSideCardinality.isToOne() && !sOldInverseSideCardinality.isToOne()) {
                            inverseSideLink.setFieldType(inverseSideLink.getTargetEntityClassName());
                        }
                        if (sNewInverseSideCardinality.isToMany() && !sOldInverseSideCardinality.isToMany()) {
                            inverseSideLink.setFieldType("java.util.List");
                        }
                    }
                    inverseSideLink.setMappedBy(link.getFieldName());
                }
                this._editorPage.applyFilterCriteria();
                this._editorPage.setDirty();
            }
        }
    }

    private void buttonRemoveLink(Button b) {
        this.log("REMOVE link ...");
        Composite row = this.getRowFromWidget(b);
        LinkInDbModel link = this.getLinkFromRow(row);
        if (link == null) {
            MsgBox.error("Row data is null (no link for this row) !");
            return;
        }
        if (link.isOwningSide()) {
            RelationLinksInDbModel relation = this.repositoryModel.getRelationByLinkId(link.getId());
            String s = "\n ( no inverse side )";
            LinkInDbModel inverseSideLink = relation.getInverseSideLink();
            Composite rowInvSide = null;
            if (inverseSideLink != null) {
                s = "\n and its inverse side ";
                rowInvSide = this.getRowByLinkId(inverseSideLink.getId());
            }
            if (MsgBox.confirm("Do you realy want to remove this link (owning side)" + s + "\n from the repository ? ")) {
                this.repositoryModel.removeRelation(relation);
                this.deleteRow(row);
                if (rowInvSide != null) {
                    this.deleteRow(rowInvSide);
                }
                this.refresh();
                this._editorPage.setDirty();
                this._editorPage.refreshCount();
            }
        } else if (MsgBox.confirm("Do you realy want to remove this link (inverse side)\n from the repository ? ")) {
            this.repositoryModel.removeLinkById(link.getId());
            this.deleteRow(row);
            this.refresh();
            this._editorPage.setDirty();
            this._editorPage.refreshCount();
        }
    }

    private Composite getRowByLinkId(String id) {
        if (id != null) {
            Composite[] rows = this.getAllRows();
            int i = 0;
            while (i < rows.length) {
                Composite row = rows[i];
                LinkInDbModel link = this.getLinkFromRow(row);
                if (id.equals(link.getId())) {
                    return row;
                }
                ++i;
            }
        } else {
            MsgBox.error("getRowByLinkId() : id is null !");
        }
        return null;
    }

    private LinkInDbModel getLinkFromRow(Composite row) {
        Object data = row.getData();
        if (data != null) {
            if (data instanceof LinkInDbModel) {
                return (LinkInDbModel)data;
            }
            MsgBox.error("Row data is not an instance of Link !");
        } else {
            MsgBox.error("Row data is null !");
        }
        return null;
    }

    @Override
    protected void deleteItemInModel(Object item) {
        if (item != null) {
            if (item instanceof LinkInDbModel) {
                LinkInDbModel link = (LinkInDbModel)item;
                this.repositoryModel.removeLinkById(link.getId());
            } else {
                MsgBox.error("deleteItemInModel : item is not an instance of Link");
            }
        } else {
            MsgBox.error("deleteItemInModel : item is null");
        }
    }
}

