/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.commons.javatypes.JavaTypes;
import org.telosys.tools.commons.javatypes.JavaTypesManager;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.eclipse.plugin.editors.dbrep.ColumnNames;
import org.telosys.tools.eclipse.plugin.editors.dbrep.GenericModifyListener;
import org.telosys.tools.eclipse.plugin.editors.dbrep.RepositoryEditor;
import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialDialogCellEditor;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableUtil;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableViewerCellModifier;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableViewerContentProvider;
import org.telosys.tools.eclipse.plugin.editors.dbrep.TableViewerLabelProvider;
import org.telosys.tools.repository.model.AttributeInDbModel;
import org.telosys.tools.repository.model.EntityInDbModel;
import org.telosys.tools.repository.model.ForeignKeyColumnInDbModel;
import org.telosys.tools.repository.model.ForeignKeyInDbModel;
import org.telosys.tools.repository.model.RepositoryModel;

class RepositoryEditorPageModelEntities
extends AbstractModelEditorPage {
    private static final int TEXT_HEIGHT = 24;
    private static final int BASIC_TABLE_STYLE = 101124;
    private boolean _bPopulateInProgress = false;
    private EntityInDbModel _currentEntity = null;
    private Combo _comboTables = null;
    private Label _labelCatalog = null;
    private Label _labelSchema = null;
    private TableViewer _tableViewer = null;
    private Text _textJavaBeanClass = null;
    private Table _tableForeignKeys = null;
    private static final int BEAN_JAVA_CLASS = 1;

    public RepositoryEditorPageModelEntities(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
    }

    protected boolean isPopulateInProgress() {
        return this._bPopulateInProgress;
    }

    protected String getModelValue(int id) {
        if (this._currentEntity != null) {
            switch (id) {
                case 1: {
                    return this._currentEntity.getClassName();
                }
            }
            MsgBox.error("getModelValue(" + id + ") : unknown id !");
        } else {
            MsgBox.error("getModelValue(" + id + ") : current entity is null !");
        }
        return "";
    }

    protected void setModelValue(int id, String v) {
        block4: {
            block3: {
                if (this._currentEntity == null) break block3;
                switch (id) {
                    case 1: {
                        this._currentEntity.setClassName(v);
                        break block4;
                    }
                    default: {
                        MsgBox.error("getModelValue(" + id + ") : unknown id !");
                        return;
                    }
                }
            }
            MsgBox.error("getModelValue(" + id + ") : current entity is null !");
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(IManagedForm) ...");
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setExpandHorizontal(true);
        Composite scrolledFormBody = scrolledForm.getBody();
        GridLayout bodyLayout = new GridLayout(1, false);
        bodyLayout.marginWidth = 10;
        scrolledFormBody.setLayout((Layout)bodyLayout);
        Util.setPageTitle(scrolledFormBody, this.getTitle());
        this.createPageHeaderGroup(scrolledFormBody);
        Composite composite = null;
        composite = new Composite(scrolledFormBody, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(768));
        TabFolder tabFolder = new TabFolder(composite, 0);
        this.createTabFolderMapping(tabFolder);
        this.createTabFolderForeignKeys(tabFolder);
        this.populateComboEntities(this._comboTables);
        this.setBodyBackgroundColor();
    }

    private Composite createPageHeaderGroup(Composite scrolledFormBody) {
        Composite group1 = new Composite(scrolledFormBody, 0);
        GridData gd = new GridData(768);
        gd.heightHint = 50;
        group1.setLayoutData((Object)gd);
        int width = 200;
        int y1 = 2;
        int y2 = 22;
        int fillerWidth = 20;
        int x = 0;
        Label label = new Label(group1, 0);
        label.setText("Database table name : ");
        label.setSize(width, 20);
        label.setLocation(x, y1);
        this._comboTables = new Combo(group1, 2056);
        this._comboTables.setSize(width, 24);
        this._comboTables.setLocation(x, y2);
        this._comboTables.setVisibleItemCount(20);
        this.setTablesComboAction(this._comboTables);
        x = x + width + fillerWidth;
        label = new Label(group1, 0);
        label.setText("Catalog : ");
        label.setSize(width, 20);
        label.setLocation(x, y1);
        this._labelCatalog = new Label(group1, 2048);
        this._labelCatalog.setText("");
        this._labelCatalog.setSize(width, 24);
        this._labelCatalog.setLocation(x, y2);
        x = x + width + fillerWidth;
        label = new Label(group1, 0);
        label.setText("Schema : ");
        label.setSize(width, 20);
        label.setLocation(x, y1);
        this._labelSchema = new Label(group1, 2048);
        this._labelSchema.setText("");
        this._labelSchema.setSize(width, 24);
        this._labelSchema.setLocation(x, y2);
        x = x + width + fillerWidth;
        label = new Label(group1, 0);
        label.setText("Entity class name : ");
        label.setSize(width, 20);
        label.setLocation(x, y1);
        this._textJavaBeanClass = new Text(group1, 2048);
        this._textJavaBeanClass.setText("");
        this._textJavaBeanClass.setSize(width, 24);
        this._textJavaBeanClass.setLocation(x, y2);
        this._textJavaBeanClass.addModifyListener((ModifyListener)new GenericModifyListener(this, 1));
        return group1;
    }

    private void populateComboEntities(Combo combo) {
        this.log((Object)this, "Populate combo Tables/Entities...");
        RepositoryModel repositoryModel = this.getRepositoryModel();
        combo.removeAll();
        Object[] tableNames = repositoryModel.getEntitiesNames();
        Arrays.sort(tableNames);
        if (tableNames != null) {
            int i = 0;
            while (i < tableNames.length) {
                Object entityName = tableNames[i];
                EntityInDbModel entity = repositoryModel.getEntityByTableName((String)entityName);
                if (!StrUtil.nullOrVoid((String)entity.getDatabaseType()) && !entity.getDatabaseType().equalsIgnoreCase("TABLE")) {
                    entityName = String.valueOf(entityName) + "   (" + entity.getDatabaseType() + ")";
                }
                combo.add((String)entityName);
                ++i;
            }
        }
        combo.setData((Object)tableNames);
        this.log((Object)this, "Populate TABLES combo : done.");
    }

    private Composite createTabFolderContainer(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolderContainer() ...");
        Composite tabContent = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 30;
        tabContent.setLayout((Layout)gridLayout);
        return tabContent;
    }

    private GridData createStandardTableGridData() {
        GridData gd = new GridData(768);
        gd.minimumHeight = 400;
        gd.minimumWidth = 500;
        gd.heightHint = 400;
        return gd;
    }

    private void createTabFolderMapping(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolder1() ...");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Mapping table - object ");
        Composite tabContent = this.createTabFolderContainer(tabFolder);
        Table table = this.createTableMapping(tabContent);
        table.setLayoutData((Object)this.createStandardTableGridData());
        tabItem.setControl((Control)tabContent);
    }

    private void createTabFolderForeignKeys(TabFolder tabFolder) {
        this.log((Object)this, "createTabFolderForeignKeys() ...");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(" Foreign keys ");
        Composite tabContent = this.createTabFolderContainer(tabFolder);
        this._tableForeignKeys = this.createTableForeignKeys(tabContent);
        this._tableForeignKeys.setLayoutData((Object)this.createStandardTableGridData());
        tabItem.setControl((Control)tabContent);
    }

    private Table createTableMapping(Composite composite) {
        this.log((Object)this, "createTable(..)...");
        int iTableStyle = 101156;
        Table table = new Table(composite, iTableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn col = null;
        int iColumnIndex = 0;
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("");
        col.setWidth(22);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("");
        col.setWidth(18);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Database Name");
        col.setWidth(150);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Database Type");
        col.setWidth(150);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("JDBC Type");
        col.setWidth(120);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Attribute Name");
        col.setWidth(150);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Attribute Type");
        col.setWidth(120);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Further info");
        col.setWidth(160);
        this._tableViewer = this.createTableViewerMapping(table);
        this.setSelectionListener(table);
        return table;
    }

    private TableViewer createTableViewerMapping(Table table) {
        this.log((Object)this, "createTableViewer(..)...");
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(ColumnNames.NAMES);
        CellEditor[] editors = new CellEditor[ColumnNames.NAMES.length];
        editors[0] = new TextCellEditor((Composite)table);
        editors[1] = new TextCellEditor((Composite)table);
        editors[2] = new TextCellEditor((Composite)table);
        editors[3] = new TextCellEditor((Composite)table);
        editors[4] = new TextCellEditor((Composite)table);
        TextCellEditor textEditor = new TextCellEditor((Composite)table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[5] = textEditor;
        JavaTypes types = JavaTypesManager.getJavaTypes();
        ComboBoxCellEditor cbEditor = new ComboBoxCellEditor((Composite)table, types.getTexts(), 8);
        Control control = cbEditor.getControl();
        if (control instanceof CCombo) {
            CCombo combo = (CCombo)control;
            combo.setVisibleItemCount(10);
        }
        editors[6] = cbEditor;
        editors[7] = new SpecialDialogCellEditor(table);
        tableViewer.setCellEditors(editors);
        tableViewer.setCellModifier((ICellModifier)new TableViewerCellModifier((RepositoryEditor)this.getEditor()));
        tableViewer.setContentProvider((IContentProvider)new TableViewerContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new TableViewerLabelProvider());
        return tableViewer;
    }

    private void loadTableEntity(String sTableName) {
        this.log((Object)this, "loadTableEntity('" + sTableName + "')");
        RepositoryModel repositoryModel = this.getRepositoryModel();
        this._currentEntity = repositoryModel.getEntityByTableName(sTableName);
        this.populateClassesFields(this._currentEntity);
        this.populateTableMapping(this._currentEntity);
        this.populateTableForeignKeys(this._currentEntity, this._tableForeignKeys);
    }

    private void populateTableMapping(EntityInDbModel entity) {
        this.log((Object)this, "populateTableMapping()...");
        this._labelCatalog.setText(this.blankIfNull(entity.getDatabaseCatalog()));
        this._labelSchema.setText(this.blankIfNull(entity.getDatabaseSchema()));
        this.log((Object)this, "populateTableWidgets() : before setInput() ---");
        this._tableViewer.setInput((Object)entity);
        this.log((Object)this, "populateTableWidgets() : after setInput() ---");
        Table table = this._tableViewer.getTable();
        TableItem[] tableItems = table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            TableItem item = tableItems[i];
            AttributeInDbModel column = TableUtil.getTableColumn(item);
            item.setChecked(column.isSelected());
            ++i;
        }
    }

    private void populateClassesFields(EntityInDbModel entity) {
        this.log((Object)this, "populateFields()...");
        this._bPopulateInProgress = true;
        this._textJavaBeanClass.setText(this.blankIfNull(entity.getClassName()));
        this._bPopulateInProgress = false;
    }

    private String blankIfNull(String s) {
        return s != null ? s : "";
    }

    private void populateTableForeignKeys(EntityInDbModel entity, Table table) {
        this.log((Object)this, "populateForeignKeysTable()...");
        ForeignKeyInDbModel[] foreignKeys = entity.getForeignKeys();
        if (foreignKeys != null) {
            table.removeAll();
            int n = foreignKeys.length;
            int i = 0;
            while (i < n) {
                ForeignKeyInDbModel fk = foreignKeys[i];
                ForeignKeyColumnInDbModel[] fkColumns = fk.getForeignKeyColumns();
                int c = 0;
                while (c < fkColumns.length) {
                    ForeignKeyColumnInDbModel fkCol = fkColumns[c];
                    TableItem tableItem = new TableItem(table, 0);
                    int col = 0;
                    String name = c == 0 ? fk.getName() : "";
                    tableItem.setText(col++, name);
                    tableItem.setText(col++, fkCol.getColumnName());
                    tableItem.setText(col++, fkCol.getTableRef());
                    tableItem.setText(col++, fkCol.getReferencedColumnName());
                    tableItem.setText(col++, String.valueOf(fkCol.getUpdateRuleCode()) + " : " + fkCol.getUpdateRuleText());
                    tableItem.setText(col++, String.valueOf(fkCol.getDeleteRuleCode()) + " : " + fkCol.getDeleteRuleText());
                    tableItem.setText(col++, String.valueOf(fkCol.getDeferrableCode()) + " : " + fkCol.getDeferrableText());
                    ++c;
                }
                ++i;
            }
        }
    }

    private Table createTableForeignKeys(Composite composite) {
        this.log((Object)this, "createForeignKeysTable(..)...");
        Table table = new Table(composite, 101124);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn col = null;
        int iColumnIndex = 0;
        int columnWidth = 160;
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("FK name");
        col.setWidth(columnWidth);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Column");
        col.setWidth(columnWidth);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Ref table");
        col.setWidth(columnWidth);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Ref column");
        col.setWidth(columnWidth);
        columnWidth = 84;
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Update rule");
        col.setWidth(columnWidth);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Delete rule");
        col.setWidth(columnWidth);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Deferrability");
        col.setWidth(columnWidth);
        return table;
    }

    private void setTablesComboAction(Combo combo) {
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Combo combo = (Combo)event.widget;
                String sTableName = "";
                int index = combo.getSelectionIndex();
                String[] tableNames = (String[])combo.getData();
                if (tableNames != null) {
                    if (index >= 0 && index < tableNames.length) {
                        sTableName = tableNames[index];
                    } else {
                        MsgBox.error("Invalid index " + index);
                    }
                } else {
                    MsgBox.error("No table names for this combo ( getData returns null )");
                }
                RepositoryEditorPageModelEntities.this.log((Object)this, "Tables combo listener : widgetSelected() : " + sTableName);
                RepositoryEditorPageModelEntities.this.loadTableEntity(sTableName);
            }
        });
    }

    private void setSelectionListener(Table table) {
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RepositoryEditorPageModelEntities.this.log(this, "*** TABLE : widgetDefaultSelected");
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem tableItem = (TableItem)e.item;
                RepositoryEditorPageModelEntities.this.log(this, "*** TABLE : widgetSelected : checked ? " + tableItem.getChecked());
                AttributeInDbModel attribute = TableUtil.getTableColumn(tableItem);
                RepositoryEditorPageModelEntities.this.log(this, "*** TABLE : widgetSelected : row : " + attribute);
                if (attribute.isKeyElement()) {
                    tableItem.setChecked(true);
                    return;
                }
                if (attribute.isSelected() != tableItem.getChecked()) {
                    attribute.setSelected(tableItem.getChecked());
                    RepositoryEditorPageModelEntities.this.setDirty();
                }
            }
        });
    }
}

