/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.commons.DateUtil;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.repository.model.RepositoryModel;

class RepositoryEditorPageModelInfo
extends AbstractModelEditorPage {
    static final String DATE_FORMAT = "MMMM dd yyyy - HH:mm:ss";

    public RepositoryEditorPageModelInfo(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(IManagedForm) ...");
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayout bodyLayout = new GridLayout();
        bodyLayout.numColumns = 2;
        bodyLayout.makeColumnsEqualWidth = false;
        body.setLayout((Layout)bodyLayout);
        GridData gdTitle = new GridData(768);
        gdTitle.horizontalSpan = 2;
        Label labelTitle = Util.setPageTitle(body, this.getTitle());
        labelTitle.setLayoutData((Object)gdTitle);
        this.addConfigRow(body, "", "");
        RepositoryModel repositoryModel = this.getRepositoryModel();
        this.addConfigRow(body, "Model name :", repositoryModel.getName());
        this.addConfigRow(body, "Model version :", repositoryModel.getVersion());
        this.addConfigRow(body, "", "");
        this.addConfigRow(body, "Model generation :", this.formatDate(repositoryModel.getGenerationDate()));
        this.addConfigRow(body, "Model last update :", this.formatDate(repositoryModel.getLastUpdateDate()));
        this.addConfigRow(body, "", "");
        this.addConfigRow(body, "Database used to generate the model", "");
        this.addConfigRow(body, ". database ID :", "" + repositoryModel.getDatabaseId());
        this.addConfigRow(body, ". database name :", repositoryModel.getDatabaseName());
        this.addConfigRow(body, ". database product name :", repositoryModel.getDatabaseProductName());
        this.setBodyBackgroundColor();
    }

    private String formatDate(Date date) {
        if (date != null) {
            return DateUtil.format((Date)date, (String)DATE_FORMAT);
        }
        return "";
    }

    private void addConfigRow(Composite c, String s1, String s2) {
        Label label1 = new Label(c, 16384);
        label1.setText(s1);
        Label label2 = new Label(c, 16384);
        label2.setText(s2);
    }
}

