/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.eclipse.plugin.editors.dbrep.LinksList;
import org.telosys.tools.repository.LinksManager;
import org.telosys.tools.repository.model.LinksCriteria;
import org.telosys.tools.repository.model.RepositoryModel;
import org.telosys.tools.repository.rules.RepositoryRulesProvider;

class RepositoryEditorPageModelLinks
extends AbstractModelEditorPage {
    private Button ckFilterOwningSide;
    private Button ckFilterInverseSide;
    private Button ckFilterManyToOne;
    private Button ckFilterOneToMany;
    private Button ckFilterManyToMany;
    private Button ckFilterOneToOne;
    private LinksList linksView;
    private Label linksCount;

    public RepositoryEditorPageModelLinks(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..) : input name = '" + input.getName() + "'");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        this.log((Object)this, "createFormContent(IManagedForm) ...");
        super.createFormContent(managedForm);
        try {
            ScrolledForm form = managedForm.getForm();
            Composite scrolledFormBody = form.getBody();
            GridLayout bodyLayout = new GridLayout(1, false);
            bodyLayout.marginWidth = 10;
            scrolledFormBody.setLayout((Layout)bodyLayout);
            Util.setPageTitle(scrolledFormBody, this.getTitle());
            this.createFilter(scrolledFormBody);
            GridData gd = new GridData(768);
            gd.heightHint = 400;
            gd.widthHint = 800;
            this.linksView = new LinksList(scrolledFormBody, gd, this);
            this.linksCount = new Label(scrolledFormBody, 16384);
            this.linksCount.setLayoutData((Object)new GridData(200, 26));
            this.createButtons(scrolledFormBody);
            List links = this.getRepositoryModel().getAllLinks();
            this.linksView.populate(links);
            this.refreshCount();
            this.setBodyBackgroundColor();
            this.log((Object)this, "createFormContent(IManagedForm) : END.");
        }
        catch (Throwable tex) {
            MsgBox.error("Exception in createFormContent()", tex);
        }
    }

    private Button createCheckBox(Composite parent, String text, GridData gd) {
        Button b = new Button(parent, 32);
        b.setText(text);
        b.setLayoutData((Object)gd);
        b.setSelection(true);
        return b;
    }

    protected void refreshCount() {
        this.linksCount.setText(this.linksView.getSize() + "/" + this.getRepositoryModel().getNumberOfLinks());
    }

    protected void applyFilterCriteria() {
        this.log("applyFilterCriteria()");
        LinksCriteria criteria = new LinksCriteria();
        criteria.setOwningSide(this.ckFilterOwningSide.getSelection());
        criteria.setInverseSide(this.ckFilterInverseSide.getSelection());
        criteria.setTypeManyToMany(this.ckFilterManyToMany.getSelection());
        criteria.setTypeManyToOne(this.ckFilterManyToOne.getSelection());
        criteria.setTypeOneToMany(this.ckFilterOneToMany.getSelection());
        criteria.setTypeOneToOne(this.ckFilterOneToOne.getSelection());
        this.log("applyFilterCriteria() : " + criteria);
        LinkedList links = this.getRepositoryModel().getLinks(criteria);
        this.linksView.repopulate(links);
        this.refreshCount();
    }

    private void setAllFilterChoices(boolean b) {
        this.ckFilterOwningSide.setSelection(b);
        this.ckFilterInverseSide.setSelection(b);
        this.ckFilterManyToOne.setSelection(b);
        this.ckFilterOneToMany.setSelection(b);
        this.ckFilterManyToMany.setSelection(b);
        this.ckFilterOneToOne.setSelection(b);
    }

    private void selectAllFilterChoices() {
        this.setAllFilterChoices(true);
    }

    private void deselectAllFilterChoices() {
        this.setAllFilterChoices(false);
    }

    private void createFilter(Composite scrolledFormBody) {
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.verticalSpacing = 0;
        Composite composite = new Composite(scrolledFormBody, 0);
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(140, 26);
        GridData gdButton = new GridData(100, 26);
        Label label = new Label(composite, 16384);
        label.setText("Filter : ");
        label.setLayoutData((Object)gd);
        this.ckFilterOwningSide = this.createCheckBox(composite, "Owning side", gd);
        this.ckFilterInverseSide = this.createCheckBox(composite, "Inverse side", gd);
        this.ckFilterOwningSide.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.ckFilterInverseSide.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label l = new Label(composite, 16384);
        l.setLayoutData((Object)gd);
        l = new Label(composite, 16384);
        l.setLayoutData((Object)gd);
        Button b = new Button(composite, 8);
        b.setText("Select All");
        b.setLayoutData((Object)gdButton);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RepositoryEditorPageModelLinks.this.selectAllFilterChoices();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        b = new Button(composite, 8);
        b.setText("Apply");
        b.setLayoutData((Object)gdButton);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RepositoryEditorPageModelLinks.this.applyFilterCriteria();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.ckFilterManyToOne = this.createCheckBox(composite, "Many To One", gd);
        this.ckFilterOneToMany = this.createCheckBox(composite, "One To Many", gd);
        this.ckFilterManyToMany = this.createCheckBox(composite, "Many To Many", gd);
        this.ckFilterOneToOne = this.createCheckBox(composite, "One To One", gd);
        b = new Button(composite, 8);
        b.setText("Deselect All");
        b.setLayoutData((Object)gdButton);
        b.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RepositoryEditorPageModelLinks.this.deselectAllFilterChoices();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createButtons(Composite scrolledFormBody) {
        Composite composite = new Composite(scrolledFormBody, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginLeft = 0;
        composite.setLayout((Layout)rowLayout);
        Button buttonRemoveLinks = new Button(composite, 0);
        buttonRemoveLinks.setText("  Remove all links  ");
        buttonRemoveLinks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String msg = "Do you realy want to remove all the links ?";
                if (MsgBox.confirm(msg)) {
                    RepositoryEditorPageModelLinks.this.removeAllLinks();
                    RepositoryEditorPageModelLinks.this.setDirty();
                    RepositoryEditorPageModelLinks.this.selectAllFilterChoices();
                    RepositoryEditorPageModelLinks.this.applyFilterCriteria();
                    RepositoryEditorPageModelLinks.this.refreshCount();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button buttonGenerate = new Button(composite, 0);
        buttonGenerate.setText("  Generate links from foreign keys  ");
        buttonGenerate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String msg = "\n Do you realy want to generate links for each Foreign Key ?\n\n Generated links will replace existing links if any.\n Both sides (owning side and inverse side) will be generated.";
                if (MsgBox.confirm(msg)) {
                    int n = RepositoryEditorPageModelLinks.this.generateLinks();
                    RepositoryEditorPageModelLinks.this.setDirty();
                    RepositoryEditorPageModelLinks.this.selectAllFilterChoices();
                    RepositoryEditorPageModelLinks.this.applyFilterCriteria();
                    RepositoryEditorPageModelLinks.this.refreshCount();
                    MsgBox.info(n + " link(s) generated.");
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button buttonAddLink = new Button(composite, 0);
        buttonAddLink.setText("  Add new link  ");
        buttonAddLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                MsgBox.info("Not yet implemented.");
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void removeAllLinks() {
        RepositoryModel repositoryModel = this.getRepositoryModel();
        repositoryModel.removeAllLinks();
    }

    private int generateLinks() {
        int n = 0;
        RepositoryModel repositoryModel = this.getRepositoryModel();
        LinksManager linksGenerator = new LinksManager(RepositoryRulesProvider.getRepositoryRules());
        try {
            n = linksGenerator.generateAllLinks(repositoryModel);
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Error /links generation - TelosysToolsException", e);
        }
        return n;
    }
}

