/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import java.math.BigDecimal;
import org.telosys.tools.commons.StrUtil;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.repository.model.AttributeInDbModel;

public abstract class SpecialValue {
    protected AttributeInDbModel _modelColumn = null;
    private final boolean _initialNotNull;
    private final String _initialDefaultValue;
    private final String _initialLabel;
    private final String _initialInputType;

    protected SpecialValue(AttributeInDbModel modelColumn) {
        this._modelColumn = modelColumn;
        this._initialNotNull = this._modelColumn.isNotNull();
        this._initialDefaultValue = this._modelColumn.getDefaultValue();
        this._initialLabel = this._modelColumn.getLabel();
        this._initialInputType = this._modelColumn.getInputType();
    }

    protected void log(String s) {
        PluginLogger.log(this, s);
    }

    public boolean isPrimitiveType() {
        return this._modelColumn.isJavaPrimitiveType();
    }

    public String getJavaType() {
        return this._modelColumn.getModelFullType();
    }

    public boolean isNotNull() {
        return this._modelColumn.isNotNull();
    }

    public void setNotNull(boolean b) {
        this._modelColumn.setNotNull(b);
    }

    public String getDefaultValue() {
        return this.emptyIfNull(this._modelColumn.getDefaultValue());
    }

    public void setDefaultValue(String v) {
        this._modelColumn.setDefaultValue(v);
    }

    public String getLabel() {
        return this.emptyIfNull(this._modelColumn.getLabel());
    }

    public void setLabel(String v) {
        this._modelColumn.setLabel(v);
    }

    public String getInputType() {
        return this.emptyIfNull(this._modelColumn.getInputType());
    }

    public void setInputType(String v) {
        this._modelColumn.setInputType(v);
    }

    protected boolean hasChanged() {
        if (this._initialNotNull != this._modelColumn.isNotNull()) {
            return true;
        }
        if (StrUtil.different((String)this._initialDefaultValue, (String)this._modelColumn.getDefaultValue())) {
            return true;
        }
        if (StrUtil.different((String)this._initialLabel, (String)this._modelColumn.getLabel())) {
            return true;
        }
        return StrUtil.different((String)this._initialInputType, (String)this._modelColumn.getInputType());
    }

    protected void cancelChanges() {
        this._modelColumn.setNotNull(this._initialNotNull);
        this._modelColumn.setDefaultValue(this._initialDefaultValue);
        this._modelColumn.setLabel(this._initialLabel);
        this._modelColumn.setInputType(this._initialInputType);
    }

    protected String emptyIfNull(String s) {
        return s != null ? s : "";
    }

    protected String emptyIfNull(Integer value) {
        return value != null ? value.toString() : "";
    }

    protected String emptyIfNull(BigDecimal value) {
        return value != null ? value.toString() : "";
    }

    protected boolean sameValue(String s1, String s2) {
        String s1bis = this.emptyIfNull(s1);
        String s2bis = this.emptyIfNull(s2);
        return s1bis.equals(s2bis);
    }

    public String toString() {
        return this._modelColumn.getSpecialTypeInfo();
    }
}

