/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dbrep;

import org.telosys.tools.eclipse.plugin.editors.dbrep.SpecialValue;
import org.telosys.tools.generic.model.DateType;
import org.telosys.tools.repository.model.AttributeInDbModel;

public class SpecialValueForDate
extends SpecialValue {
    private DateType _initialDateType = this._modelColumn.getDateType();
    private boolean _initialDatePast = this._modelColumn.isDatePast();
    private boolean _initialDateFuture = this._modelColumn.isDateFuture();
    private boolean _initialDateBefore = this._modelColumn.isDateBefore();
    private boolean _initialDateAfter;
    private String _initialDateBeforeValue = this._modelColumn.getDateBeforeValue();
    private String _initialDateAfterValue = null;

    public SpecialValueForDate(AttributeInDbModel modelColumn) {
        super(modelColumn);
        this._initialDateAfter = this._modelColumn.isDateAfter();
        this._initialDateAfterValue = this._modelColumn.getDateAfterValue();
    }

    public boolean isDateOnly() {
        return this._modelColumn.getDateType() == DateType.DATE_ONLY;
    }

    public void setDateOnly() {
        this._modelColumn.setDateType(DateType.DATE_ONLY);
    }

    public boolean isTimeOnly() {
        return this._modelColumn.getDateType() == DateType.TIME_ONLY;
    }

    public void setTimeOnly() {
        this._modelColumn.setDateType(DateType.TIME_ONLY);
    }

    public boolean isDateAndTime() {
        return this._modelColumn.getDateType() == DateType.DATE_AND_TIME;
    }

    public void setDateAndTime() {
        this._modelColumn.setDateType(DateType.DATE_AND_TIME);
    }

    public void setDateValidationNotNull(boolean b) {
        this.log("setDateValidationNotNull(" + b + ")");
        this._modelColumn.setNotNull(b);
    }

    public void setDateValidationPast(boolean b) {
        this.log("setDateValidationPast(" + b + ")");
        this._modelColumn.setDatePast(b);
    }

    public void setDateValidationFuture(boolean b) {
        this.log("setDateValidationFuture(" + b + ")");
        this._modelColumn.setDateFuture(b);
    }

    public void setDateValidationBefore(boolean b, String s) {
        this.log("setDateValidationBefore(" + b + "," + s + ")");
        this._modelColumn.setDateBefore(b);
        this._modelColumn.setDateBeforeValue(s);
    }

    public void setDateValidationAfter(boolean b, String s) {
        this.log("setDateValidationAfter(" + b + "," + s + ")");
        this._modelColumn.setDateAfter(b);
        this._modelColumn.setDateAfterValue(s);
    }

    public boolean isDateValidationNotNull() {
        return this._modelColumn.isNotNull();
    }

    public boolean isDateValidationPast() {
        this.log("isDateValidationPast() : " + this._modelColumn.isDatePast());
        return this._modelColumn.isDatePast();
    }

    public boolean isDateValidationFuture() {
        this.log("isDateValidationFuture() : " + this._modelColumn.isDateFuture());
        return this._modelColumn.isDateFuture();
    }

    public boolean isDateValidationBefore() {
        return this._modelColumn.isDateBefore();
    }

    public boolean isDateValidationAfter() {
        return this._modelColumn.isDateAfter();
    }

    public String getDateValidationBefore() {
        return this._modelColumn.getDateBeforeValue();
    }

    public String getDateValidationAfter() {
        return this._modelColumn.getDateAfterValue();
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this._initialDateType != this._modelColumn.getDateType()) {
            return true;
        }
        if (this._initialDatePast != this._modelColumn.isDatePast()) {
            return true;
        }
        if (this._initialDateFuture != this._modelColumn.isDateFuture()) {
            return true;
        }
        if (this._initialDateBefore != this._modelColumn.isDateBefore()) {
            return true;
        }
        if (!this.sameValue(this._initialDateBeforeValue, this._modelColumn.getDateBeforeValue())) {
            return true;
        }
        if (this._initialDateAfter != this._modelColumn.isDateAfter()) {
            return true;
        }
        return !this.sameValue(this._initialDateAfterValue, this._modelColumn.getDateAfterValue());
    }

    @Override
    public void cancelChanges() {
        super.cancelChanges();
        this._modelColumn.setDateType(this._initialDateType);
        this._modelColumn.setDatePast(this._initialDatePast);
        this._modelColumn.setDateFuture(this._initialDateFuture);
        this._modelColumn.setDateBefore(this._initialDateBefore);
        this._modelColumn.setDateBeforeValue(this._initialDateBeforeValue);
        this._modelColumn.setDateAfter(this._initialDateAfter);
        this._modelColumn.setDateAfterValue(this._initialDateAfterValue);
    }
}

