/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorContentAssistTools;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorSuggestContext;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorWordProvider;

public class EntityEditorContentAssistProcessor
implements IContentAssistProcessor {
    private final EntityEditorWordProvider wordProvider = new EntityEditorWordProvider();
    private String lastError;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentOffset) {
        EntityEditorSuggestContext suggestContext;
        List<String> suggestions;
        IDocument document = textViewer.getDocument();
        String docSubPart = EntityEditorContentAssistTools.getDocumentSubPart(document, documentOffset);
        if (docSubPart != null && docSubPart.length() > 0 && (suggestions = this.wordProvider.suggest((suggestContext = EntityEditorContentAssistTools.getSuggestContext(docSubPart)).getWord(), suggestContext.getContext())) != null && suggestions.size() > 0) {
            String originalWord = suggestContext.getWord();
            int originalWordOffset = documentOffset - originalWord.length();
            return this.buildProposals(suggestions, originalWord, originalWordOffset);
        }
        return null;
    }

    private ICompletionProposal[] buildProposals(List<String> suggestions, String replacedWord, int offset) {
        ICompletionProposal[] proposals = new ICompletionProposal[suggestions.size()];
        int index = 0;
        Iterator<String> iterator = suggestions.iterator();
        while (iterator.hasNext()) {
            String suggestion;
            String replacementString = suggestion = iterator.next();
            int replacementOffset = offset;
            int replacementLength = replacedWord.length();
            int cursorPosition = suggestion.length();
            if (replacementString.endsWith(")")) {
                --cursorPosition;
            }
            CompletionProposal cp = new CompletionProposal(replacementString, replacementOffset, replacementLength, cursorPosition);
            proposals[index++] = cp;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer itextviewer, int i) {
        this.lastError = "No Context Information available";
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.lastError;
    }
}

