/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorContext;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorSuggestContext;

public class EntityEditorContentAssistTools {
    private static final char[] VOID_CHARACTERS = new char[]{' ', '\t', '\n', '\r'};
    private static final char[] SPECIAL_CHARACTERS = new char[]{':', ';', ',', '{', '}', '[', ']'};

    public static String getDocumentSubPart(IDocument document, int documentOffset) {
        StringBuffer sb = new StringBuffer();
        int lastChar = 0;
        int offset = documentOffset > 0 ? documentOffset - 1 : documentOffset;
        try {
            char c = document.getChar(offset);
            while (offset > 0) {
                sb.append(c);
                lastChar = c;
                if (c != ':') {
                    c = document.getChar(--offset);
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Error in document parsing for suggest (BadLocationException)");
        }
        if (lastChar == 58) {
            return sb.reverse().toString();
        }
        return null;
    }

    public static EntityEditorSuggestContext getSuggestContext(String s) {
        int bracesFound = 0;
        char lastChar = '\u0000';
        boolean endOfWord = false;
        char firstLeftSeparator = '\u0000';
        int firstLeftChar = 0;
        StringBuffer sbReversedWord = new StringBuffer();
        int i = s.length() - 1;
        while (i >= 0) {
            char c;
            lastChar = c = s.charAt(i);
            if (EntityEditorContentAssistTools.isVoidChar(c)) {
                endOfWord = true;
            } else {
                if (EntityEditorContentAssistTools.isSpecialChar(c)) {
                    endOfWord = true;
                    if (firstLeftSeparator == '\u0000') {
                        firstLeftSeparator = c;
                    }
                }
                if (endOfWord && firstLeftChar == 0) {
                    firstLeftChar = c;
                }
            }
            if (!endOfWord) {
                sbReversedWord.append(c);
            } else {
                if (c == ':') break;
                if (c == '{') {
                    ++bracesFound;
                }
            }
            --i;
        }
        String word = sbReversedWord.reverse().toString();
        if (lastChar != ':') {
            return new EntityEditorSuggestContext(word, EntityEditorContext.DEFAULT);
        }
        if (firstLeftChar == 123) {
            return new EntityEditorSuggestContext(word, EntityEditorContext.ANNOTATION);
        }
        if (firstLeftChar == 44 && bracesFound > 0) {
            return new EntityEditorSuggestContext(word, EntityEditorContext.ANNOTATION);
        }
        if (firstLeftChar == 58) {
            return new EntityEditorSuggestContext(word, EntityEditorContext.TYPE);
        }
        return new EntityEditorSuggestContext(word, EntityEditorContext.DEFAULT);
    }

    private static boolean isVoidChar(char c) {
        char[] cArray = VOID_CHARACTERS;
        int n = VOID_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char voidChar = cArray[n2];
            if (voidChar == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isSpecialChar(char c) {
        char[] cArray = SPECIAL_CHARACTERS;
        int n = SPECIAL_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char specialChar = cArray[n2];
            if (specialChar == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

