/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.EntityEditorUtil;
import org.telosys.tools.eclipse.plugin.editors.dsl.entityeditor.completion.EntityEditorContext;

public class EntityEditorWordProvider {
    private static final String DOT_ENTITY = ".entity";

    public List<String> suggest(String beginningOfWord, EntityEditorContext context) {
        ArrayList<String> suggestedWords = new ArrayList<String>();
        switch (context) {
            case TYPE: {
                String[] stringArray = EntityEditorUtil.getEntityFieldTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (str.startsWith(beginningOfWord)) {
                        suggestedWords.add(String.valueOf(str) + " ");
                    }
                    ++n2;
                }
                for (String str : this.getListOfDefinedEntities()) {
                    if (!str.startsWith(beginningOfWord)) continue;
                    suggestedWords.add(String.valueOf(str) + " ");
                }
                break;
            }
            case ANNOTATION: {
                String[] stringArray = EntityEditorUtil.getAnnotationsWithParenthesis();
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String str = stringArray[n3];
                    if (str.startsWith(beginningOfWord)) {
                        suggestedWords.add(str);
                    }
                    ++n3;
                }
                break;
            }
        }
        return suggestedWords;
    }

    private List<String> getListOfDefinedEntities() {
        ArrayList<String> fileList = new ArrayList<String>();
        FilenameFilter entitiesFilter = new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(EntityEditorWordProvider.DOT_ENTITY);
            }
        };
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        IEditorInput input = editor.getEditorInput();
        IPath path = ((FileEditorInput)input).getPath();
        File currentFolder = new File(path.toFile().getParent());
        String[] stringArray = currentFolder.list(entitiesFilter);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            str = str.replace(DOT_ENTITY, "");
            str = String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
            fileList.add(str);
            ++n2;
        }
        return fileList;
    }
}

