/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.model;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.telosys.tools.api.GenericModelLoader;
import org.telosys.tools.api.TelosysModelException;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.dsl.DslModelManager;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.dsl.parser.model.DomainModelInfo;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageCodeGeneration;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageModelEntities;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditorPageModelInfo;
import org.telosys.tools.generic.model.Model;

public class ModelEditor
extends AbstractModelEditor {
    private Image _imageWithoutError = null;
    private ModelEditorPageModelEntities _modelEntitiesPage = null;
    private ModelEditorPageModelInfo _modelInformationPage = null;
    private List<String> _entitiesFileNames = null;
    private Map<String, String> _entitiesErrors = null;
    private DomainModelInfo _modelInfo = null;

    public List<String> getEntitiesAbsoluteFileNames() {
        return this._entitiesFileNames;
    }

    public Map<String, String> getEntitiesErrors() {
        return this._entitiesErrors;
    }

    public DomainModelInfo getDomainModelInfo() {
        return this._modelInfo;
    }

    public void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.log((Object)this, "init()...");
        ImageDescriptor imageDescriptor = input.getImageDescriptor();
        if (imageDescriptor != null) {
            this._imageWithoutError = imageDescriptor.createImage();
        }
    }

    public void dispose() {
        super.dispose();
        this._imageWithoutError.dispose();
    }

    protected void addPages() {
        this.log((Object)this, "addPages()...");
        this._modelEntitiesPage = new ModelEditorPageModelEntities(this, "ModelEditorPage1", " Model entities ");
        this._modelInformationPage = new ModelEditorPageModelInfo(this, "ModelEditorPage2", " Model information ");
        ModelEditorPageCodeGeneration codeGenerationPage = new ModelEditorPageCodeGeneration(this, "ModelEditorPage3", " Code generation ");
        try {
            this.addPage((IFormPage)this._modelEntitiesPage);
            this.addPage((IFormPage)this._modelInformationPage);
            this.addPage((IFormPage)codeGenerationPage);
        }
        catch (PartInitException e) {
            MsgBox.error("RepositoryEditor : addPage(page) throws PartInitException ", e);
        }
        this.setCodeGenerationPage(codeGenerationPage);
        this.log((Object)this, "addPages() : DONE");
    }

    @Override
    protected Model loadModel(File modelFile) {
        this._entitiesFileNames = DslModelUtil.getEntitiesAbsoluteFileNames((File)modelFile);
        DslModelManager modelManager = new DslModelManager();
        this._modelInfo = modelManager.loadModelInformation(modelFile);
        GenericModelLoader genericModelLoader = new GenericModelLoader(this.getProjectConfig());
        try {
            Model model = genericModelLoader.loadModel(modelFile);
            this._entitiesErrors = null;
            return model;
        }
        catch (TelosysModelException modelException) {
            this._entitiesErrors = modelException.getParsingErrors();
            return null;
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Cannot load model !\n Unexpected exception", e);
            return null;
        }
    }

    @Override
    protected void saveModel(Model model, File modelFile) {
        if (this._modelInformationPage != null) {
            if (this._modelInfo != null) {
                this._modelInformationPage.updateModelInformation(this._modelInfo);
                DslModelManager modelManager = new DslModelManager();
                modelManager.saveModelInformation(modelFile, this._modelInfo);
            } else {
                MsgBox.error("ModelInfo is null in the editor !");
            }
        } else {
            MsgBox.error("_modelInformationPage is null in the editor !");
        }
    }

    public void refresh() {
        this.log((Object)this, "refresh()...");
        this.loadModel();
        int errorsCount = this._modelEntitiesPage.populateEntities();
        this.log((Object)this, "refresh() : errorsCount = " + errorsCount);
        if (errorsCount > 0) {
            Image errorImage = PluginImages.getImage("ERROR");
            this.log((Object)this, "refresh() : setTitleImage(errorImage) ");
            this.setTitleImage(errorImage);
        } else {
            this.setTitleImage(this._imageWithoutError);
        }
    }
}

