/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.model;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.FileEditorUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.DialogBoxForNewEntity;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.DialogBoxForRenameEntity;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.TableContextMenuListener;

class ModelEditorPageModelEntities
extends AbstractModelEditorPage {
    private Table _entitiesTable = null;
    private static final int BUTTON_WIDTH = 120;

    public ModelEditorPageModelEntities(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(..) : Entities Page");
        GridLayout bodyLayout = new GridLayout();
        bodyLayout.numColumns = 1;
        bodyLayout.makeColumnsEqualWidth = false;
        Composite scrolledFormBody = this.initAndGetFormBody(managedForm, (Layout)bodyLayout);
        Composite titlePanel = this.createTitleAndButtons(scrolledFormBody);
        titlePanel.setLayoutData((Object)new GridData(768));
        this._entitiesTable = this.createEntitiesTable(scrolledFormBody);
        GridData gd = new GridData(4, 4, true, true);
        this._entitiesTable.setLayoutData((Object)gd);
        this.setBodyBackgroundColor();
        this.refresh();
    }

    private Shell getShell() {
        return this._entitiesTable.getDisplay().getActiveShell();
    }

    protected void doOpenEntityInEditor(String entityAbsoluteFilePath) {
        FileEditorUtil.openEntityFileInEditor(entityAbsoluteFilePath);
    }

    protected void doNewEntity() {
        DialogBoxForNewEntity dialogBox = new DialogBoxForNewEntity(this.getShell());
        if (dialogBox.open() == 0) {
            String entityName = dialogBox.getEntityName();
            try {
                File entityFile = DslModelUtil.createNewEntity((File)this.getModelFile(), (String)entityName);
                EclipseWksUtil.refresh(entityFile);
                this.doOpenEntityInEditor(entityFile.getAbsolutePath());
            }
            catch (Exception e) {
                MsgBox.error("Cannot create entity '" + entityName + "'", e);
            }
        }
    }

    protected void doDeleteEntity(String entityAbsoluteFilePath) {
        File entityFile = new File(entityAbsoluteFilePath);
        String entityName = DslModelUtil.getEntityName((File)entityFile);
        if (MsgBox.confirm("Confirm delete", "Do you realy want to delete entity '" + entityName + "' ?")) {
            boolean deleted = entityFile.delete();
            if (deleted) {
                EclipseWksUtil.refresh(entityFile);
            } else {
                MsgBox.error("Cannot delete entity '" + entityName + "' !");
            }
        }
    }

    protected void doRenameEntity(String entityAbsoluteFilePath) {
        String currentEntityName = DslModelUtil.getEntityName((File)new File(entityAbsoluteFilePath));
        DialogBoxForRenameEntity dialogBox = new DialogBoxForRenameEntity(this.getShell(), currentEntityName);
        if (dialogBox.open() == 0) {
            String newEntityName = dialogBox.getNewEntityName();
            DslModelUtil.renameEntity((File)new File(entityAbsoluteFilePath), (String)newEntityName);
            File modelFolder = DslModelUtil.getModelFolder((File)this.getModelFile());
            EclipseWksUtil.refresh(modelFolder);
        }
    }

    protected TableItem getSelectedTableItem() {
        TableItem[] selectedItems = this._entitiesTable.getSelection();
        if (selectedItems != null && selectedItems.length == 1) {
            return selectedItems[0];
        }
        return null;
    }

    private Composite createTitleAndButtons(Composite formBodyComposite) {
        Composite panel = new Composite(formBodyComposite, 0);
        panel.setLayout((Layout)new RowLayout());
        Util.setPageTitle(panel, this.getTitle());
        Label filler = new Label(panel, 0);
        filler.setText("");
        filler.setLayoutData((Object)new RowData(80, -1));
        Button refreshButton = new Button(panel, 0);
        refreshButton.setText(" Refresh");
        refreshButton.setLayoutData((Object)new RowData(120, -1));
        refreshButton.setImage(PluginImages.getImage("REFRESH"));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelEditorPageModelEntities.this.log("button click : [ Refresh ]");
                ModelEditorPageModelEntities.this.refresh();
            }
        });
        Button newButton = new Button(panel, 0);
        newButton.setText(" New entity");
        newButton.setLayoutData((Object)new RowData(120, -1));
        newButton.setImage(PluginImages.getImage("ENTITY_FILE"));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelEditorPageModelEntities.this.doNewEntity();
            }
        });
        return panel;
    }

    private Table createEntitiesTable(Composite formBodyComposite) {
        int iTableStyle = 101124;
        final Table table = new Table(formBodyComposite, iTableStyle);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn col = null;
        int iColumnIndex = 0;
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Entity file name");
        col.setWidth(200);
        col = new TableColumn(table, 16384, iColumnIndex++);
        col.setText("Entity parsing error");
        col.setWidth(500);
        this.createMenu(table);
        table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (table.getSelectionCount() > 0) {
                    TableItem[] tableItemsSelected = table.getSelection();
                    String entityAbsoluteFilePath = "?";
                    if (tableItemsSelected != null && tableItemsSelected.length == 1) {
                        entityAbsoluteFilePath = (String)tableItemsSelected[0].getData();
                        ModelEditorPageModelEntities.this.doOpenEntityInEditor(entityAbsoluteFilePath);
                    }
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        table.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = ModelEditorPageModelEntities.this.getTableItemClicked(table, event);
                if (tableItem == null) {
                    event.doit = false;
                }
            }
        });
        return table;
    }

    private Menu createMenu(Table table) {
        Menu menu = new Menu((Control)table);
        table.setMenu(menu);
        menu.setData((Object)table);
        this.createMenuItem(menu, null, "Open", new TableContextMenuListener(this, 2));
        this.createMenuItem(menu, null, "Rename", new TableContextMenuListener(this, 3));
        this.createMenuItem(menu, null, "Delete", new TableContextMenuListener(this, 4));
        return menu;
    }

    private MenuItem createMenuItem(Menu menu, Image image, String text, Listener listener) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(text);
        if (image != null) {
            menuItem.setImage(image);
        }
        menuItem.addListener(13, listener);
        menuItem.setData(menu.getData());
        return menuItem;
    }

    private TableItem getTableItemClicked(Table table, Event event) {
        Point point = Display.getDefault().map(null, (Control)table, new Point(event.x, event.y));
        TableItem tableItem = table.getItem(point);
        return tableItem;
    }

    private void refresh() {
        this.log("refresh()...");
        ModelEditor modelEditor = (ModelEditor)this.getModelEditor();
        modelEditor.refresh();
    }

    protected int populateEntities() {
        String globalError;
        this.log((Object)this, "populateEntities(table)");
        int errorsCount = 0;
        this._entitiesTable.removeAll();
        ModelEditor modelEditor = (ModelEditor)this.getModelEditor();
        List<String> entitiesFileNames = modelEditor.getEntitiesAbsoluteFileNames();
        Map<String, String> entitiesErrors = modelEditor.getEntitiesErrors();
        for (String entityFile : entitiesFileNames) {
            String entityFileName = new File(entityFile).getName();
            String entityError = null;
            String imageId = "ENTITY_FILE";
            if (entitiesErrors != null && (entityError = entitiesErrors.get(entityFileName)) != null) {
                imageId = "ERROR";
                ++errorsCount;
            }
            if (entityError == null) {
                entityError = "";
            }
            String[] row = new String[]{entityFileName, entityError};
            TableItem tableItem = new TableItem(this._entitiesTable, 0);
            tableItem.setText(row);
            tableItem.setChecked(false);
            tableItem.setData((Object)entityFile);
            tableItem.setImage(PluginImages.getImage(imageId));
        }
        if (entitiesErrors != null && (globalError = entitiesErrors.get("")) != null) {
            MsgBox.error(globalError);
        }
        return errorsCount;
    }
}

