/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.dsl.model;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.telosys.tools.dsl.parser.model.DomainModelInfo;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.editors.commons.AbstractModelEditorPage;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditor;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.TextFieldModifyListener;

class ModelEditorPageModelInfo
extends AbstractModelEditorPage {
    private boolean _bPopulateInProgress = false;
    private Text _tFileName;
    private Text _tName;
    private Text _tVersion;
    private Text _tDescription;

    public ModelEditorPageModelInfo(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.log((Object)this, "constructor(.., '" + id + "', '" + title + "')...");
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.log((Object)this, "init(..,..) :  input name = '" + input.getName() + "'");
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.log((Object)this, "createFormContent(..) : Model Info Page");
        this.setBodyBackgroundColor();
        GridLayout bodyLayout = new GridLayout();
        bodyLayout.numColumns = 2;
        bodyLayout.makeColumnsEqualWidth = false;
        Composite scrolledFormBody = this.initAndGetFormBody(managedForm, (Layout)bodyLayout);
        Label labelTitle = Util.setPageTitle(scrolledFormBody, this.getTitle());
        GridData gdTitle = new GridData(768);
        gdTitle.horizontalSpan = 2;
        labelTitle.setLayoutData((Object)gdTitle);
        this.addRow(scrolledFormBody, "", "");
        this._tFileName = this.addLabelAndText(scrolledFormBody, "File : ");
        this._tFileName.setEditable(false);
        this._tName = this.addLabelAndText(scrolledFormBody, "Name : ");
        this._tVersion = this.addLabelAndText(scrolledFormBody, "Version : ");
        this._tDescription = this.addLabelAndTextMulti(scrolledFormBody, "Description : ");
        this.populateFields();
    }

    protected boolean isPopulateInProgress() {
        return this._bPopulateInProgress;
    }

    protected void updateModelInformation(DomainModelInfo modelInfo) {
        modelInfo.setName(this._tName.getText());
        modelInfo.setVersion(this._tVersion.getText());
        modelInfo.setDescription(this._tDescription.getText());
    }

    private void populateFields() {
        this.log((Object)this, "populateFields()");
        this.getStandardEditor().setPopulateInProgress(true);
        String modelFileAbsolutePath = this.getModelEditor().getFileAbsolutePath();
        this._tFileName.setText(modelFileAbsolutePath);
        DomainModelInfo modelInfo = ((ModelEditor)this.getModelEditor()).getDomainModelInfo();
        if (modelInfo != null) {
            this._tName.setText(modelInfo.getName());
            this._tVersion.setText(modelInfo.getVersion());
            this._tDescription.setText(modelInfo.getDescription());
        }
        this.getStandardEditor().setPopulateInProgress(false);
    }

    private Text addLabelAndText(Composite c, String labelText) {
        Label label1 = new Label(c, 16384);
        label1.setText(labelText);
        Text text = new Text(c, 2048);
        text.addModifyListener((ModifyListener)new TextFieldModifyListener(this.getStandardEditor()));
        GridData gd = new GridData();
        gd.widthHint = 400;
        text.setLayoutData((Object)gd);
        return text;
    }

    private Text addLabelAndTextMulti(Composite c, String labelText) {
        Label label = new Label(c, 16384);
        label.setText(labelText);
        GridData labelGridData = new GridData();
        labelGridData.verticalAlignment = 1;
        labelGridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)labelGridData);
        Text text = new Text(c, 2818);
        text.addModifyListener((ModifyListener)new TextFieldModifyListener(this.getStandardEditor()));
        new TextFieldModifyListener(this.getStandardEditor());
        GridData textGridData = new GridData(400, 200);
        textGridData.verticalAlignment = 1;
        textGridData.grabExcessVerticalSpace = true;
        text.setLayoutData((Object)textGridData);
        return text;
    }

    private void addRow(Composite c, String labelText1, String labelText2) {
        Label label = new Label(c, 16384);
        label.setText(labelText1);
        label = new Label(c, 16384);
        label.setText(labelText2);
    }
}

