/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.telosys.tools.eclipse.plugin.editors.velocity.ColorManager;
import org.telosys.tools.eclipse.plugin.editors.velocity.VelocityDamagerRepairer;
import org.telosys.tools.eclipse.plugin.editors.velocity.VelocityDoubleClickStrategy;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.VelocityContentAssistProcessor;
import org.telosys.tools.eclipse.plugin.editors.velocity.scanner.code.VelocityCodeScanner;
import org.telosys.tools.eclipse.plugin.editors.velocity.scanner.partition.VelocityPartitionScanner;

public class VelocityEditorConfiguration
extends SourceViewerConfiguration {
    private VelocityDoubleClickStrategy doubleClickStrategy;
    private VelocityCodeScanner codeScanner;
    private ColorManager colorManager;
    private ContentAssistant assistant;

    public VelocityEditorConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return VelocityPartitionScanner.TYPES;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new VelocityDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    private VelocityCodeScanner getVelocityCodeScanner() {
        if (this.codeScanner == null) {
            this.codeScanner = new VelocityCodeScanner(this.colorManager);
            this.codeScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ColorManager.RGB_VELOCITY_DEFAULT))));
        }
        return this.codeScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getVelocityCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        VelocityDamagerRepairer ndr = new VelocityDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorManager.RGB_VELOCITY_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__velocity_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__velocity_multiline_comment");
        ndr = new VelocityDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorManager.RGB_VELOCITY_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__velocity_document_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__velocity_document_comment");
        ndr = new VelocityDamagerRepairer(new TextAttribute(this.colorManager.getColor(ColorManager.RGB_VELOCITY_COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__velocity_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__velocity_singleline_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistant == null) {
            this.assistant = new ContentAssistant();
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)new VelocityContentAssistProcessor(), "__dftl_partition_content_type");
            this.assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.assistant.enableAutoActivation(true);
            this.assistant.setAutoActivationDelay(0);
        }
        return this.assistant;
    }
}

