/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.ContentAssistConfiguration;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.IContextObjectInfo;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWord;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWords;

public class VelocityKeyWordProvider {
    private IContextObjectInfo contextObjectInfo;

    public VelocityKeyWordProvider(IContextObjectInfo contextObjectInfo) {
        this.contextObjectInfo = contextObjectInfo;
    }

    public List<VelocityKeyWord> suggest(String word) {
        ArrayList<VelocityKeyWord> wordBuffer = new ArrayList<VelocityKeyWord>();
        wordBuffer.addAll(this.filterSuggestions(VelocityKeyWords.getKeyWords(), word));
        wordBuffer.addAll(this.filterSuggestions(this.contextObjectInfo.getPredefineVariables(), word));
        wordBuffer.addAll(this.filterSuggestions(this.contextObjectInfo.getContextBeans(), word));
        return wordBuffer;
    }

    public List<VelocityKeyWord> suggestContextVariableOutline(String variableName, String filter) {
        ArrayList<VelocityKeyWord> wordBuffer = new ArrayList<VelocityKeyWord>();
        List<VelocityKeyWord> completions = this.filterSuggestions(this.contextObjectInfo.getBeanInfo(variableName), filter);
        if (completions.isEmpty()) {
            String customzableVariableNames = ContentAssistConfiguration.getConfigurationValue("velocity.editor.beanVariableSuffixable");
            String[] allowedPrefixes = customzableVariableNames.split(";");
            int i = 0;
            while (i < allowedPrefixes.length) {
                if (variableName.startsWith(allowedPrefixes[i])) {
                    completions = this.filterSuggestions(this.contextObjectInfo.getBeanInfo(allowedPrefixes[i]), filter);
                    wordBuffer.addAll(completions);
                    break;
                }
                ++i;
            }
        } else {
            wordBuffer.addAll(completions);
        }
        return wordBuffer;
    }

    private List<VelocityKeyWord> filterSuggestions(List<VelocityKeyWord> allSuggestions, String filter) {
        ArrayList<VelocityKeyWord> listFiltered = new ArrayList();
        if (filter == null) {
            filter = "";
        }
        if (filter.isEmpty()) {
            listFiltered = allSuggestions;
        } else {
            for (VelocityKeyWord keyword : allSuggestions) {
                if (!keyword.getDisplayValue().startsWith(filter.replaceAll("^\\$\\{", "\\$"))) continue;
                listFiltered.add(keyword);
            }
        }
        return listFiltered;
    }
}

