/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.editors.velocity.scanner.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.telosys.tools.eclipse.plugin.editors.velocity.ColorManager;
import org.telosys.tools.eclipse.plugin.editors.velocity.contentassist.TelosysGeneratorObjectInfo;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWord;
import org.telosys.tools.eclipse.plugin.editors.velocity.model.VelocityKeyWords;
import org.telosys.tools.eclipse.plugin.editors.velocity.scanner.code.IdentifierDetector;
import org.telosys.tools.eclipse.plugin.editors.velocity.scanner.code.VelocityDirectiveDetector;
import org.telosys.tools.eclipse.plugin.editors.velocity.scanner.code.VelocityWhitespaceDetector;

public class VelocityCodeScanner
extends RuleBasedScanner {
    public VelocityCodeScanner(ColorManager manager) {
        ArrayList<Object> rulesList = new ArrayList<Object>();
        rulesList.add(new WhitespaceRule((IWhitespaceDetector)new VelocityWhitespaceDetector()));
        rulesList.add(this.getDirectiveRule(manager));
        rulesList.addAll(this.getReferenceRule(manager));
        IRule[] rulesArray = new IRule[rulesList.size()];
        rulesList.toArray(rulesArray);
        this.setRules(rulesArray);
    }

    private List<IRule> getReferenceRule(ColorManager manager) {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Color referenceColor = manager.getColor(ColorManager.RGB_VELOCITY_REFERENCE);
        Token token = new Token((Object)new TextAttribute(referenceColor, null, 1));
        TelosysGeneratorObjectInfo context = new TelosysGeneratorObjectInfo();
        List<VelocityKeyWord> words = context.getPredefineVariables();
        words.addAll(context.getContextBeans());
        for (VelocityKeyWord reference : words) {
            for (String formatName : this.getAllFormalFormattedNameFor(reference.getValue())) {
                rules.add((IRule)new PatternRule(formatName, "}", (IToken)token, '\u0000', true));
            }
            for (String formatName : this.getAllShortHandFormattedNameFor(reference.getValue())) {
                rules.add((IRule)new WordPatternRule((IWordDetector)new IdentifierDetector(), formatName, null, (IToken)token));
            }
        }
        token = new Token((Object)new TextAttribute(referenceColor, null, 2));
        rules.add((IRule)new PatternRule("$!{", "}", (IToken)token, '\u0000', true));
        rules.add((IRule)new PatternRule("${", "}", (IToken)token, '\u0000', true));
        rules.add((IRule)new WordPatternRule((IWordDetector)new IdentifierDetector(), "$!", null, (IToken)token));
        rules.add((IRule)new WordPatternRule((IWordDetector)new IdentifierDetector(), "$", null, (IToken)token));
        return rules;
    }

    private WordRule getDirectiveRule(ColorManager colorManager) {
        String[] directives;
        Color directiveColor = colorManager.getColor(ColorManager.RGB_VELOCITY_DIRECTIVE);
        Token token = new Token((Object)new TextAttribute(directiveColor));
        WordRule wordRule = new WordRule((IWordDetector)new VelocityDirectiveDetector(), (IToken)token);
        token = new Token((Object)new TextAttribute(directiveColor, null, 1));
        String[] stringArray = directives = VelocityKeyWords.getAllDirectives();
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            String directive = stringArray[n2];
            wordRule.addWord(directive, (IToken)token);
            ++n2;
        }
        return wordRule;
    }

    private List<String> getAllShortHandFormattedNameFor(String name) {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("$" + name);
        formats.add("$" + name + ".");
        formats.add("$!" + name);
        formats.add("$!" + name + ".");
        return formats;
    }

    private List<String> getAllFormalFormattedNameFor(String name) {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("${" + name);
        formats.add("${" + name + ".");
        formats.add("$!{" + name);
        formats.add("$!{" + name + ".");
        return formats;
    }
}

