/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.generator;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.commons.TelosysToolsLogger;
import org.telosys.tools.commons.bundles.TargetDefinition;
import org.telosys.tools.commons.cfg.TelosysToolsCfg;
import org.telosys.tools.commons.io.CopyHandler;
import org.telosys.tools.commons.io.OverwriteChooser;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.Util;
import org.telosys.tools.eclipse.plugin.commons.dialogbox.GenerationTaskMsgBox;
import org.telosys.tools.eclipse.plugin.generator.CopyHandlerForRefresh;
import org.telosys.tools.eclipse.plugin.generator.OverwriteChooserDialogBox;
import org.telosys.tools.eclipse.plugin.generator.TaskMonitor;
import org.telosys.tools.generator.context.Target;
import org.telosys.tools.generator.task.AbstractGenerationTask;
import org.telosys.tools.generator.task.ErrorReport;
import org.telosys.tools.generator.task.GenerationTask;
import org.telosys.tools.generator.task.GenerationTaskResult;
import org.telosys.tools.generator.task.ITaskMonitor;
import org.telosys.tools.generic.model.Model;

public class GenerationTaskWithProgress
extends AbstractGenerationTask
implements GenerationTask,
IRunnableWithProgress {
    public GenerationTaskWithProgress(Model model, LinkedList<String> selectedEntities, String bundleName, LinkedList<TargetDefinition> selectedTargets, List<TargetDefinition> resourcesTargets, TelosysToolsCfg telosysToolsCfg, TelosysToolsLogger logger) throws TelosysToolsException {
        super(model, selectedEntities, bundleName, selectedTargets, resourcesTargets, telosysToolsCfg, logger);
    }

    protected boolean onError(ErrorReport errorReport) {
        boolean r = GenerationTaskMsgBox.error(errorReport.getErrorType(), errorReport.getMessage(), errorReport.getException());
        return r;
    }

    protected void afterFileGeneration(Target target, String fullFileName) {
        this.log("afterFileGeneration(" + fullFileName + ")");
        EclipseWksUtil.refresh(new File(fullFileName));
    }

    public GenerationTaskResult launch() {
        boolean originalFlag = EclipseWksUtil.setBuildAutomatically(false);
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Util.getActiveWindowShell());
        try {
            this.log("Run generation task ...");
            progressMonitorDialog.run(false, false, (IRunnableWithProgress)this);
            this.log("End of generation task.");
            GenerationTaskResult generationTaskResult = super.getResult();
            MsgBox.info("End of generation task.\n\n" + generationTaskResult.getNumberOfResourcesCopied() + " resources(s) copied." + "\n\n" + generationTaskResult.getNumberOfFilesGenerated() + " file(s) generated." + "\n\n" + generationTaskResult.getNumberOfGenerationErrors() + " generation error(s).");
        }
        catch (InvocationTargetException invocationTargetException) {
            this.onError(this.buildErrorReport(invocationTargetException));
        }
        catch (InterruptedException interruptedException) {
            GenerationTaskResult generationTaskResult = super.getResult();
            MsgBox.warning("GENERATION CANCELED !\n\n\n\n" + generationTaskResult.getNumberOfResourcesCopied() + " resources(s) copied." + "\n\n" + generationTaskResult.getNumberOfFilesGenerated() + " file(s) generated." + "\n\n" + generationTaskResult.getNumberOfGenerationErrors() + " generation error(s).");
        }
        EclipseWksUtil.setBuildAutomatically(originalFlag);
        return super.getResult();
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.log("run");
        OverwriteChooserDialogBox overwriteChooser = new OverwriteChooserDialogBox();
        CopyHandlerForRefresh copyHandler = new CopyHandlerForRefresh();
        TaskMonitor taskMonitor = new TaskMonitor(progressMonitor);
        super.runTask((ITaskMonitor)taskMonitor, (OverwriteChooser)overwriteChooser, (CopyHandler)copyHandler);
    }
}

