/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

public class SettingsManager {
    private static final String ERR_CANNOT_LOAD = "Cannot load properties.\n";
    private static final String ERR_CANNOT_SAVE = "Cannot save properties.\n";
    private static final String SETTINGS_FILE = ".settings/org.telosys.tools.settings";
    private static final String BUNDLE = "bundle";
    private final IProject _project;

    public SettingsManager(IProject project) {
        if (project == null) {
            MsgBox.error("SettingsManager constructor error : IProject is null !");
        }
        this._project = project;
    }

    private String getBundleStaticResourcesCopiedKey(String bundleName) {
        return "bundle." + bundleName + ".staticResourcesCopied";
    }

    public void updateBundleStaticResourcesCopiedFlag(String bundleName, boolean value) {
        this.updateProperty(this.getBundleStaticResourcesCopiedKey(bundleName), "" + value);
    }

    public boolean readBundleStaticResourcesCopiedFlag(String bundleName) {
        String value = this.loadProperty(this.getBundleStaticResourcesCopiedKey(bundleName));
        if (value != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    private void updateProperty(String key, String value) {
        Properties properties = this.load();
        properties.setProperty(key, value);
        this.save(properties);
    }

    private String loadProperty(String key) {
        Properties properties = this.load();
        return properties.getProperty(key);
    }

    private Properties load() {
        String filePath = EclipseProjUtil.getAbsolutePathInFileSystem(this._project, SETTINGS_FILE);
        File file = new File(filePath);
        return this.load(file);
    }

    private void save(Properties properties) {
        String filePath = EclipseProjUtil.getAbsolutePathInFileSystem(this._project, SETTINGS_FILE);
        File file = new File(filePath);
        this.save(file, properties);
    }

    private Properties load(File file) {
        Properties properties;
        block15: {
            properties = new Properties();
            if (!file.exists()) {
                return properties;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (IOException ioe) {
                    MsgBox.error("Cannot load properties.\nIOException : \n", ioe);
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private void save(File file, Properties properties) {
        block15: {
            boolean r;
            File dir;
            if (!(file.exists() || (dir = file.getParentFile()).exists() || (r = dir.mkdir()))) {
                MsgBox.error("Cannot create directory '" + dir.getPath() + "'");
            }
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    properties.store(fos, "Telosys plugin properties");
                }
                catch (IOException ioe) {
                    MsgBox.error("Cannot save properties.\nIOException : \n" + ioe.getMessage());
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

