/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.toolbar;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class ActionOpenProperties
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        IProject iProject = this.getCurrentProject(true);
        if (iProject != null) {
            this.log("project found : " + iProject.getName());
            EclipseProjUtil.openTelosysPropertiesView(iProject);
        } else {
            MsgBox.info("No project selected.\n\nPlease select a project or one of its files.");
        }
    }

    private void log(String msg) {
        PluginLogger.log(msg);
    }

    private void message(boolean silent, String message) {
        if (!silent) {
            MsgBox.info(message);
        }
    }

    private IProject getCurrentProject(boolean silent) {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            ISelection selection = workbenchWindow.getSelectionService().getSelection();
            if (selection != null) {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    return this.getProjectFromStructuredSelection(structuredSelection, silent);
                }
                this.message(silent, "Cannot identify current project from current selection.\nThe selection is not a 'IStructuredSelection' \n\nClass : " + selection.getClass().getCanonicalName() + "\n" + selection);
            } else {
                this.message(silent, "Cannot identify current project : no active selection.\n");
            }
        } else {
            this.message(silent, "Cannot identify current project : no active WorkbenchWindow.\n");
        }
        return null;
    }

    private IProject getProjectFromStructuredSelection(IStructuredSelection selection, boolean silent) {
        this.log("selection size = " + selection.size());
        if (selection.isEmpty()) {
            this.message(silent, "Cannot identify current project (nothing selected)");
            return null;
        }
        if (selection.size() > 1) {
            this.message(silent, "Cannot identify current project (multiple items selected)");
            return null;
        }
        Object selectedElement = selection.getFirstElement();
        this.log("Only one item selected : " + selectedElement);
        IProject project = this.getProject(selectedElement);
        if (project == null) {
            this.message(silent, "Cannot get current project from selected element.\n\nClass : " + selectedElement.getClass().getCanonicalName() + "\n" + selectedElement);
        }
        return project;
    }

    private IProject getProject(Object selected) {
        this.log("getProject( " + selected + ")");
        IResource resource = (IResource)Platform.getAdapterManager().getAdapter(selected, IResource.class);
        if (resource != null) {
            IProject project = resource.getProject();
            return project;
        }
        return null;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

