/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wizards.dslmodel;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.telosys.tools.api.TelosysProject;
import org.telosys.tools.commons.TelosysToolsException;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.FileEditorUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.wizards.dslmodel.NewDslModelWizardPage;

public class NewDslModelWizard
extends Wizard
implements INewWizard {
    private IProject projectSelected = null;
    private NewDslModelWizardPage page1;

    private void log(String msg) {
        PluginLogger.log((Object)this, msg);
    }

    public NewDslModelWizard() {
        this.log("Constructor");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.log("init()");
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IResource) {
                this.projectSelected = ((IResource)firstElement).getProject();
                this.log("init : Current project " + this.projectSelected.getName());
            }
        } else {
            this.projectSelected = null;
            this.log("init : No current project ");
        }
    }

    public void addPages() {
        this.log("addPages()");
        this.page1 = new NewDslModelWizardPage(this.projectSelected);
        this.addPage((IWizardPage)this.page1);
    }

    public String getWindowTitle() {
        this.log("getWindowTitle()");
        return "New DSL model";
    }

    public boolean performFinish() {
        this.log("performFinish() : project path = " + this.page1.getProjectPath());
        this.log("performFinish() : model name = " + this.page1.getModelName());
        this.createNewModel();
        return true;
    }

    public boolean performCancel() {
        this.log("performCancel() ");
        return super.performCancel();
    }

    private void createNewModel() {
        File modelFile;
        String projectAbsolutePath = this.page1.getProjectPath();
        String modelName = this.page1.getModelName();
        this.log("createNewModel() : " + projectAbsolutePath + " " + modelName);
        TelosysProject telosysProject = new TelosysProject(projectAbsolutePath);
        try {
            modelFile = telosysProject.getDslModelFile(modelName);
            if (modelFile.exists()) {
                MsgBox.error("Model '" + modelName + "' already exists");
                return;
            }
        }
        catch (TelosysToolsException e) {
            MsgBox.error("Unexpected error", e);
            return;
        }
        try {
            modelFile = telosysProject.createNewDslModel(modelName);
            EclipseWksUtil.refresh(DslModelUtil.getModelFolder((File)modelFile));
            EclipseWksUtil.refresh(modelFile);
            FileEditorUtil.openModelFileInEditor(modelFile.getAbsolutePath());
        }
        catch (Exception e) {
            MsgBox.error("Cannot create model", e);
        }
    }
}

