/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wizards.dslmodel;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.telosys.tools.eclipse.plugin.commons.EclipseProjUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.commons.MsgBox;

public class NewDslModelWizardPage
extends WizardPage {
    private IProject _projectSelected;
    private Text _tModelName;

    protected NewDslModelWizardPage(IProject project) {
        super("NewDslModelWizardPage");
        this.setTitle("New DSL Model");
        this.setDescription("Create a new DSL model");
        this._projectSelected = project;
    }

    protected String getProjectPath() {
        if (this._projectSelected != null) {
            return EclipseProjUtil.getProjectDir(this._projectSelected);
        }
        MsgBox.error("Invalid state : no project selected");
        return null;
    }

    protected String getModelName() {
        return this._tModelName.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.createProjectLine(container);
        Label label1 = new Label(container, 0);
        label1.setText("Model name");
        this._tModelName = new Text(container, 2052);
        this._tModelName.setText("");
        this._tModelName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                NewDslModelWizardPage.this.checkPageComplete();
            }
        });
        GridData gd = new GridData(768);
        this._tModelName.setLayoutData((Object)gd);
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void createProjectLine(Composite container) {
        Label label = new Label(container, 0);
        label.setText("Project :");
        GridData gd = new GridData(768);
        if (this._projectSelected != null) {
            label = new Label(container, 0);
            label.setText(this._projectSelected.getName());
            label.setLayoutData((Object)gd);
        } else {
            Combo combo = new Combo(container, 2056);
            combo.setVisibleItemCount(10);
            combo.setLayoutData((Object)gd);
            this.populateProjectsComboBox(combo);
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Combo combo = (Combo)event.widget;
                    if (combo.getSelectionIndex() >= 0) {
                        int index = combo.getSelectionIndex();
                        List projectsList = (List)combo.getData();
                        NewDslModelWizardPage.this._projectSelected = (IProject)projectsList.get(index);
                        NewDslModelWizardPage.this.checkPageComplete();
                    }
                }
            });
        }
    }

    private void populateProjectsComboBox(Combo combo) {
        combo.removeAll();
        LinkedList<IProject> projectsList = new LinkedList<IProject>();
        IProject[] iProjectArray = EclipseWksUtil.getWorkspaceProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            combo.add(project.getName());
            projectsList.add(project);
            ++n2;
        }
        combo.setData(projectsList);
    }

    private void checkPageComplete() {
        if (!this._tModelName.getText().isEmpty() && this._projectSelected != null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }
}

