/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wkschanges;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.swt.widgets.Display;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.commons.EclipseWksUtil;
import org.telosys.tools.eclipse.plugin.wkschanges.RefreshJob;
import org.telosys.tools.eclipse.plugin.wkschanges.TaskModelEditorClose;

public class ModelChangesProcessor {
    private static void log(String msg) {
    }

    public static void processModelChange(IResourceDelta delta) {
        ModelChangesProcessor.log("processModelChange(delta)");
        switch (delta.getKind()) {
            case 1: {
                ModelChangesProcessor.modelFileAdded(delta);
                break;
            }
            case 2: {
                ModelChangesProcessor.modelFileRemoved(delta);
                break;
            }
            case 4: {
                ModelChangesProcessor.modelFileChanged(delta);
            }
        }
    }

    private static void modelFileAdded(IResourceDelta delta) {
        IResource res = delta.getResource();
        ModelChangesProcessor.log("MODEL ADDED (nothing to do) : " + res.getFullPath());
    }

    private static void modelFileRemoved(IResourceDelta delta) {
        IResource res = delta.getResource();
        ModelChangesProcessor.log("MODEL REMOVED : " + res.getFullPath());
        File modelFile = EclipseWksUtil.toFile((IFile)delta.getResource());
        ModelChangesProcessor.log("modelFile.getAbsolutePath() = " + modelFile.getAbsolutePath());
        DslModelUtil.deleteModel((File)modelFile);
        ModelChangesProcessor.log("Model file and folder deleted.");
        RefreshJob refreshJob = new RefreshJob(modelFile.getParentFile());
        refreshJob.schedule();
        ModelChangesProcessor.log("refreshJob.schedule() done.");
        ModelChangesProcessor.closeModelEditor(modelFile);
    }

    private static void closeModelEditor(File modelFile) {
        ModelChangesProcessor.log("closeModelEditor()");
        Display.getDefault().asyncExec((Runnable)new TaskModelEditorClose(modelFile));
    }

    private static void modelFileChanged(IResourceDelta delta) {
        IResource res = delta.getResource();
        ModelChangesProcessor.log("MODEL CHANGED (nothing to do) : " + res.getFullPath());
    }
}

