/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wkschanges;

import java.io.File;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.telosys.tools.dsl.DslModelUtil;
import org.telosys.tools.eclipse.plugin.editors.dsl.model.ModelEditor;

public class ModelEditorFinder {
    private static void log(String msg) {
    }

    public static ModelEditor findModelEditorForEntityFile(File entityFile) {
        if (entityFile != null) {
            File modelFile = DslModelUtil.getModelFileForEntityFile((File)entityFile);
            return ModelEditorFinder.findModelEditorForModelFile(modelFile);
        }
        return null;
    }

    public static ModelEditor findModelEditorForModelFile(File modelFile) {
        IEditorReference[] editors;
        if (modelFile != null && (editors = ModelEditorFinder.getEditors()) != null) {
            ModelEditorFinder.log("Editors ( count = " + editors.length + " )");
            IEditorReference[] iEditorReferenceArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                ModelEditorFinder.log(" editor.getId()   = " + editor.getId());
                ModelEditorFinder.log(" editor.getName() = " + editor.getName());
                if (ModelEditorFinder.isModelEditor(editor)) {
                    ModelEditorFinder.log(" this editor is a 'ModelEditor' ");
                    ModelEditor modelEditor = ModelEditorFinder.getModelEditor(editor);
                    if (modelEditor != null) {
                        ModelEditorFinder.log(" ModelEditor instance found : file name = " + modelEditor.getShortFileName());
                        File modelEditorFile = modelEditor.getModelFile();
                        ModelEditorFinder.log(" ModelEditor instance found : model file = " + modelEditorFile.getName());
                        if (modelFile.getAbsolutePath().equals(modelEditorFile.getAbsolutePath())) {
                            ModelEditorFinder.log(" Same file => return ModelEditor ...");
                            return modelEditor;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private static IEditorReference[] getEditors() {
        ModelEditorFinder.log("getEditors()...");
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            if (workbenchPage != null) {
                return workbenchPage.getEditorReferences();
            }
        } else {
            ModelEditorFinder.log("getEditors() : IWorkbenchWindow is null => no editor");
        }
        return null;
    }

    private static boolean isModelEditor(IEditorReference editor) {
        return editor.getId().endsWith(".ModelEditor") && editor.getName().endsWith(".model");
    }

    private static ModelEditor getModelEditor(IEditorReference editor) {
        IEditorPart editorPart = editor.getEditor(true);
        if (editorPart != null) {
            if (editorPart instanceof ModelEditor) {
                return (ModelEditor)editorPart;
            }
            ModelEditorFinder.log("ERROR : editor is not an instance of ModelEditor !!!");
        } else {
            ModelEditorFinder.log("ERROR : editorPart is null !!!");
        }
        return null;
    }
}

