/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wkschanges.deco;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.telosys.tools.eclipse.plugin.commons.PluginImages;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;
import org.telosys.tools.eclipse.plugin.wkschanges.deco.FileMarker;

public class FileDecorator
extends LabelProvider
implements ILabelDecorator {
    public Image decorateImage(Image image, Object element) {
        PluginLogger.debug("decorateImage(image, element) : element class " + element.getClass());
        if (this.hasErrorMarker(element)) {
            return this.getTelosysToolsFolderImage();
        }
        return null;
    }

    public Image getTelosysToolsFolderImage() {
        return PluginImages.getImage("TELOSYS_FOLDER");
    }

    public String decorateText(String text, Object element) {
        PluginLogger.debug("decorateText('" + text + "', element) : element class " + element.getClass());
        if (this.hasErrorMarker(element)) {
            return "( ! )" + text;
        }
        return text;
    }

    private boolean hasErrorMarker(Object object) {
        PluginLogger.debug("hasErrorMarker(Object object) ");
        if (object != null) {
            PluginLogger.debug("hasErrorMarker(Object object) : object is not null");
            if (object instanceof IResource) {
                IResource resource = (IResource)object;
                PluginLogger.debug("hasErrorMarker(Object object) : object is a IResource, name = " + resource.getName());
                if (resource.exists()) {
                    IMarker errorMarker = FileMarker.findErrorMarker(resource);
                    if (errorMarker != null) {
                        PluginLogger.debug("hasErrorMarker(Object object) : IResource has an error marker");
                        return true;
                    }
                    PluginLogger.debug("hasErrorMarker(Object object) : IResource doesn't have an error marker");
                } else {
                    PluginLogger.debug("hasErrorMarker(Object object) : IResource doesn't exist");
                }
            } else {
                PluginLogger.debug("hasErrorMarker(Object object) : object is NOT a IResource");
            }
        } else {
            PluginLogger.debug("hasErrorMarker(Object object) : object is NULL");
        }
        return false;
    }
}

