/*
 * Decompiled with CFR 0.152.
 */
package org.telosys.tools.eclipse.plugin.wkschanges.deco;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.telosys.tools.eclipse.plugin.commons.PluginLogger;

public class FileMarker {
    private static final String MARKER_ID = "com.ibm.mymarkers.mymarker";

    public static final void setErrorMarker(IResource resource) {
        PluginLogger.debug("setErrorMarker " + resource.getName());
        if (FileMarker.findErrorMarker(resource) != null) {
            PluginLogger.debug("setErrorMarker " + resource.getName() + " already marked");
        } else {
            PluginLogger.debug("setErrorMarker " + resource.getName() + " not yet marked => create marker");
            IMarker marker = null;
            try {
                marker = resource.createMarker(MARKER_ID);
                marker.setAttribute("description", (Object)"this is one of my markers");
                marker.setAttribute("message", (Object)"Error");
                PluginLogger.debug("setErrorMarker " + resource.getName() + " marked / ERROR");
            }
            catch (CoreException e) {
                throw new RuntimeException("ERROR : setErrorMarker CoreException", e);
            }
        }
    }

    public static final void removeErrorMarker(IResource resource) {
        PluginLogger.debug("removeErrorMarker " + resource.getName());
        IMarker[] markers = null;
        try {
            markers = resource.findMarkers(MARKER_ID, true, 0);
        }
        catch (CoreException e) {
            throw new RuntimeException("ERROR : removeErrorMarker / resource.findMarkers", e);
        }
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                try {
                    m.delete();
                }
                catch (CoreException e) {
                    throw new RuntimeException("ERROR : removeErrorMarker / marker.delete", e);
                }
                ++n2;
            }
        }
    }

    public static final IMarker findErrorMarker(IResource resource) {
        PluginLogger.debug("findErrorMarker " + resource.getName());
        IMarker[] markers = null;
        try {
            markers = resource.findMarkers(MARKER_ID, true, 0);
        }
        catch (CoreException e) {
            throw new RuntimeException("ERROR : findErrorMarker / resource.findMarkers", e);
        }
        if (markers == null) {
            PluginLogger.debug("findErrorMarker markers == null ");
            return null;
        }
        if (markers.length == 0) {
            PluginLogger.debug("findErrorMarker markers length == 0 ");
            return null;
        }
        if (markers.length == 1) {
            PluginLogger.debug("findErrorMarker markers length == 1 ");
            return markers[0];
        }
        PluginLogger.debug("findErrorMarker markers length > 1 !!! (?)");
        return markers[0];
    }
}

